/*
 * Decompiled with CFR 0.152.
 */
package global.maplink.freight.schema;

import global.maplink.freight.schema.FreightCalculationResult;
import global.maplink.freight.schema.GoodsType;
import global.maplink.freight.schema.OperationType;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import lombok.Generated;

public class FreightCalculationResponse {
    private final String source;
    private final Map<OperationType, Map<Integer, Map<GoodsType, FreightCalculationResult>>> results;
    private final BigDecimal minimumFreight;
    private final BigDecimal minimumFreightWithCosts;

    public Optional<FreightCalculationResult> getResult(OperationType operationType, Integer axis, GoodsType goodsType) {
        return Optional.ofNullable(this.results).map(this.byKey(operationType)).map(this.byKey(axis)).map(this.byKey(goodsType));
    }

    private <T, R> Function<Map<T, R>, R> byKey(T key) {
        return map -> map.get(key);
    }

    @Generated
    public static FreightCalculationResponseBuilder builder() {
        return new FreightCalculationResponseBuilder();
    }

    @Generated
    public String getSource() {
        return this.source;
    }

    @Generated
    public Map<OperationType, Map<Integer, Map<GoodsType, FreightCalculationResult>>> getResults() {
        return this.results;
    }

    @Generated
    public BigDecimal getMinimumFreight() {
        return this.minimumFreight;
    }

    @Generated
    public BigDecimal getMinimumFreightWithCosts() {
        return this.minimumFreightWithCosts;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FreightCalculationResponse)) {
            return false;
        }
        FreightCalculationResponse other = (FreightCalculationResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$source = this.getSource();
        String other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        Map<OperationType, Map<Integer, Map<GoodsType, FreightCalculationResult>>> this$results = this.getResults();
        Map<OperationType, Map<Integer, Map<GoodsType, FreightCalculationResult>>> other$results = other.getResults();
        if (this$results == null ? other$results != null : !((Object)this$results).equals(other$results)) {
            return false;
        }
        BigDecimal this$minimumFreight = this.getMinimumFreight();
        BigDecimal other$minimumFreight = other.getMinimumFreight();
        if (this$minimumFreight == null ? other$minimumFreight != null : !((Object)this$minimumFreight).equals(other$minimumFreight)) {
            return false;
        }
        BigDecimal this$minimumFreightWithCosts = this.getMinimumFreightWithCosts();
        BigDecimal other$minimumFreightWithCosts = other.getMinimumFreightWithCosts();
        return !(this$minimumFreightWithCosts == null ? other$minimumFreightWithCosts != null : !((Object)this$minimumFreightWithCosts).equals(other$minimumFreightWithCosts));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FreightCalculationResponse;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        Map<OperationType, Map<Integer, Map<GoodsType, FreightCalculationResult>>> $results = this.getResults();
        result = result * 59 + ($results == null ? 43 : ((Object)$results).hashCode());
        BigDecimal $minimumFreight = this.getMinimumFreight();
        result = result * 59 + ($minimumFreight == null ? 43 : ((Object)$minimumFreight).hashCode());
        BigDecimal $minimumFreightWithCosts = this.getMinimumFreightWithCosts();
        result = result * 59 + ($minimumFreightWithCosts == null ? 43 : ((Object)$minimumFreightWithCosts).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FreightCalculationResponse(source=" + this.getSource() + ", results=" + this.getResults() + ", minimumFreight=" + this.getMinimumFreight() + ", minimumFreightWithCosts=" + this.getMinimumFreightWithCosts() + ")";
    }

    @Generated
    private FreightCalculationResponse(String source, Map<OperationType, Map<Integer, Map<GoodsType, FreightCalculationResult>>> results, BigDecimal minimumFreight, BigDecimal minimumFreightWithCosts) {
        this.source = source;
        this.results = results;
        this.minimumFreight = minimumFreight;
        this.minimumFreightWithCosts = minimumFreightWithCosts;
    }

    @Generated
    public static FreightCalculationResponse of(String source, Map<OperationType, Map<Integer, Map<GoodsType, FreightCalculationResult>>> results, BigDecimal minimumFreight, BigDecimal minimumFreightWithCosts) {
        return new FreightCalculationResponse(source, results, minimumFreight, minimumFreightWithCosts);
    }

    @Generated
    private FreightCalculationResponse() {
        this.source = null;
        this.results = null;
        this.minimumFreight = null;
        this.minimumFreightWithCosts = null;
    }

    @Generated
    public static class FreightCalculationResponseBuilder {
        @Generated
        private String source;
        @Generated
        private Map<OperationType, Map<Integer, Map<GoodsType, FreightCalculationResult>>> results;
        @Generated
        private BigDecimal minimumFreight;
        @Generated
        private BigDecimal minimumFreightWithCosts;

        @Generated
        FreightCalculationResponseBuilder() {
        }

        @Generated
        public FreightCalculationResponseBuilder source(String source) {
            this.source = source;
            return this;
        }

        @Generated
        public FreightCalculationResponseBuilder results(Map<OperationType, Map<Integer, Map<GoodsType, FreightCalculationResult>>> results) {
            this.results = results;
            return this;
        }

        @Generated
        public FreightCalculationResponseBuilder minimumFreight(BigDecimal minimumFreight) {
            this.minimumFreight = minimumFreight;
            return this;
        }

        @Generated
        public FreightCalculationResponseBuilder minimumFreightWithCosts(BigDecimal minimumFreightWithCosts) {
            this.minimumFreightWithCosts = minimumFreightWithCosts;
            return this;
        }

        @Generated
        public FreightCalculationResponse build() {
            return new FreightCalculationResponse(this.source, this.results, this.minimumFreight, this.minimumFreightWithCosts);
        }

        @Generated
        public String toString() {
            return "FreightCalculationResponse.FreightCalculationResponseBuilder(source=" + this.source + ", results=" + this.results + ", minimumFreight=" + this.minimumFreight + ", minimumFreightWithCosts=" + this.minimumFreightWithCosts + ")";
        }
    }
}

