/*
 * Decompiled with CFR 0.152.
 */
package global.maplink.geocode.schema.crossCities;

import global.maplink.env.Environment;
import global.maplink.geocode.schema.GeocodeServiceRequest;
import global.maplink.http.request.Request;
import global.maplink.http.request.RequestBody;
import global.maplink.json.JsonMapper;
import java.math.BigDecimal;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;

public class CrossCitiesRequest
implements GeocodeServiceRequest {
    public static final String PATH = "geocode/v1/cross-cities";
    private final List<Point> route;

    public Request asHttpRequest(Environment environment, JsonMapper mapper) {
        return Request.post((URL)environment.withService(PATH), (RequestBody)RequestBody.Json.of((Object)this, (JsonMapper)mapper));
    }

    public static Point point(BigDecimal latitude, BigDecimal longitude) {
        return Point.of(latitude, longitude);
    }

    public static Point point(double latitude, double longitude) {
        return Point.of(BigDecimal.valueOf(latitude), BigDecimal.valueOf(longitude));
    }

    @Generated
    public static CrossCitiesRequestBuilder builder() {
        return new CrossCitiesRequestBuilder();
    }

    @Generated
    public List<Point> getRoute() {
        return this.route;
    }

    @Generated
    public String toString() {
        return "CrossCitiesRequest(route=" + this.getRoute() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CrossCitiesRequest)) {
            return false;
        }
        CrossCitiesRequest other = (CrossCitiesRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Point> this$route = this.getRoute();
        List<Point> other$route = other.getRoute();
        return !(this$route == null ? other$route != null : !((Object)this$route).equals(other$route));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CrossCitiesRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Point> $route = this.getRoute();
        result = result * 59 + ($route == null ? 43 : ((Object)$route).hashCode());
        return result;
    }

    @Generated
    private CrossCitiesRequest(List<Point> route) {
        this.route = route;
    }

    @Generated
    public static CrossCitiesRequest of(List<Point> route) {
        return new CrossCitiesRequest(route);
    }

    @Generated
    public static class CrossCitiesRequestBuilder {
        @Generated
        private ArrayList<Point> route;

        @Generated
        CrossCitiesRequestBuilder() {
        }

        @Generated
        public CrossCitiesRequestBuilder point(Point point) {
            if (this.route == null) {
                this.route = new ArrayList();
            }
            this.route.add(point);
            return this;
        }

        @Generated
        public CrossCitiesRequestBuilder route(Collection<? extends Point> route) {
            if (route == null) {
                throw new NullPointerException("route cannot be null");
            }
            if (this.route == null) {
                this.route = new ArrayList();
            }
            this.route.addAll(route);
            return this;
        }

        @Generated
        public CrossCitiesRequestBuilder clearRoute() {
            if (this.route != null) {
                this.route.clear();
            }
            return this;
        }

        @Generated
        public CrossCitiesRequest build() {
            List<Object> route;
            switch (this.route == null ? 0 : this.route.size()) {
                case 0: {
                    route = Collections.emptyList();
                    break;
                }
                case 1: {
                    route = Collections.singletonList(this.route.get(0));
                    break;
                }
                default: {
                    route = Collections.unmodifiableList(new ArrayList<Point>(this.route));
                }
            }
            return new CrossCitiesRequest(route);
        }

        @Generated
        public String toString() {
            return "CrossCitiesRequest.CrossCitiesRequestBuilder(route=" + this.route + ")";
        }
    }

    public static class Point {
        private final BigDecimal latitude;
        private final BigDecimal longitude;

        @Generated
        public BigDecimal getLatitude() {
            return this.latitude;
        }

        @Generated
        public BigDecimal getLongitude() {
            return this.longitude;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Point)) {
                return false;
            }
            Point other = (Point)o;
            if (!other.canEqual(this)) {
                return false;
            }
            BigDecimal this$latitude = this.getLatitude();
            BigDecimal other$latitude = other.getLatitude();
            if (this$latitude == null ? other$latitude != null : !((Object)this$latitude).equals(other$latitude)) {
                return false;
            }
            BigDecimal this$longitude = this.getLongitude();
            BigDecimal other$longitude = other.getLongitude();
            return !(this$longitude == null ? other$longitude != null : !((Object)this$longitude).equals(other$longitude));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Point;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BigDecimal $latitude = this.getLatitude();
            result = result * 59 + ($latitude == null ? 43 : ((Object)$latitude).hashCode());
            BigDecimal $longitude = this.getLongitude();
            result = result * 59 + ($longitude == null ? 43 : ((Object)$longitude).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "CrossCitiesRequest.Point(latitude=" + this.getLatitude() + ", longitude=" + this.getLongitude() + ")";
        }

        @Generated
        private Point(BigDecimal latitude, BigDecimal longitude) {
            this.latitude = latitude;
            this.longitude = longitude;
        }

        @Generated
        public static Point of(BigDecimal latitude, BigDecimal longitude) {
            return new Point(latitude, longitude);
        }
    }
}

