/*
 * Decompiled with CFR 0.152.
 */
package global.maplink.geocode.schema.reverse;

import global.maplink.env.Environment;
import global.maplink.geocode.schema.GeocodeSplittableRequest;
import global.maplink.http.request.Request;
import global.maplink.http.request.RequestBody;
import global.maplink.json.JsonMapper;
import java.math.BigDecimal;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;

public class ReverseRequest
implements GeocodeSplittableRequest {
    public static final String PATH = "geocode/v1/reverse";
    public static final int ENTRY_LIMIT = 200;
    private final List<Entry> entries;

    public List<ReverseRequest> split() {
        if (this.entries.size() < 200) {
            return Collections.singletonList(this);
        }
        int parts = this.entries.size() / 200 + 1;
        return IntStream.range(0, parts).map(i -> i * 200).mapToObj(i -> this.entries.subList(i, Math.min(i + 200, this.entries.size()))).map(ReverseRequest::new).collect(Collectors.toList());
    }

    public static Entry entry(double lat, double lon) {
        return Entry.builder().lat(BigDecimal.valueOf(lat)).lon(BigDecimal.valueOf(lon)).build();
    }

    public static Entry entry(String id, double lat, double lon) {
        return Entry.builder().id(id).lat(BigDecimal.valueOf(lat)).lon(BigDecimal.valueOf(lon)).build();
    }

    public static Entry entry(String id, double lat, double lon, int distance) {
        return Entry.builder().id(id).lat(BigDecimal.valueOf(lat)).lon(BigDecimal.valueOf(lon)).distance(distance).build();
    }

    public static Entry entry(BigDecimal lat, BigDecimal lon) {
        return Entry.builder().lat(lat).lon(lon).build();
    }

    public static Entry entry(String id, BigDecimal lat, BigDecimal lon) {
        return Entry.builder().id(id).lat(lat).lon(lon).build();
    }

    public static Entry entry(String id, BigDecimal lat, BigDecimal lon, int distance) {
        return Entry.builder().id(id).lat(lat).lon(lon).distance(distance).build();
    }

    public Request asHttpRequest(Environment environment, JsonMapper mapper) {
        return Request.post((URL)environment.withService(PATH), (RequestBody)RequestBody.Json.of(this.entries, (JsonMapper)mapper));
    }

    @Generated
    public static ReverseRequestBuilder builder() {
        return new ReverseRequestBuilder();
    }

    @Generated
    public List<Entry> getEntries() {
        return this.entries;
    }

    @Generated
    public String toString() {
        return "ReverseRequest(entries=" + this.getEntries() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReverseRequest)) {
            return false;
        }
        ReverseRequest other = (ReverseRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Entry> this$entries = this.getEntries();
        List<Entry> other$entries = other.getEntries();
        return !(this$entries == null ? other$entries != null : !((Object)this$entries).equals(other$entries));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ReverseRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Entry> $entries = this.getEntries();
        result = result * 59 + ($entries == null ? 43 : ((Object)$entries).hashCode());
        return result;
    }

    @Generated
    private ReverseRequest(List<Entry> entries) {
        this.entries = entries;
    }

    @Generated
    public static ReverseRequest of(List<Entry> entries) {
        return new ReverseRequest(entries);
    }

    @Generated
    public static class ReverseRequestBuilder {
        @Generated
        private ArrayList<Entry> entries;

        @Generated
        ReverseRequestBuilder() {
        }

        @Generated
        public ReverseRequestBuilder entry(Entry entry) {
            if (this.entries == null) {
                this.entries = new ArrayList();
            }
            this.entries.add(entry);
            return this;
        }

        @Generated
        public ReverseRequestBuilder entries(Collection<? extends Entry> entries) {
            if (entries == null) {
                throw new NullPointerException("entries cannot be null");
            }
            if (this.entries == null) {
                this.entries = new ArrayList();
            }
            this.entries.addAll(entries);
            return this;
        }

        @Generated
        public ReverseRequestBuilder clearEntries() {
            if (this.entries != null) {
                this.entries.clear();
            }
            return this;
        }

        @Generated
        public ReverseRequest build() {
            List<Object> entries;
            switch (this.entries == null ? 0 : this.entries.size()) {
                case 0: {
                    entries = Collections.emptyList();
                    break;
                }
                case 1: {
                    entries = Collections.singletonList(this.entries.get(0));
                    break;
                }
                default: {
                    entries = Collections.unmodifiableList(new ArrayList<Entry>(this.entries));
                }
            }
            return new ReverseRequest(entries);
        }

        @Generated
        public String toString() {
            return "ReverseRequest.ReverseRequestBuilder(entries=" + this.entries + ")";
        }
    }

    public static class Entry {
        private String id;
        private final BigDecimal lat;
        private final BigDecimal lon;
        private Integer distance;

        @Generated
        Entry(String id, BigDecimal lat, BigDecimal lon, Integer distance) {
            this.id = id;
            this.lat = lat;
            this.lon = lon;
            this.distance = distance;
        }

        @Generated
        public static EntryBuilder builder() {
            return new EntryBuilder();
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public BigDecimal getLat() {
            return this.lat;
        }

        @Generated
        public BigDecimal getLon() {
            return this.lon;
        }

        @Generated
        public Integer getDistance() {
            return this.distance;
        }

        @Generated
        public String toString() {
            return "ReverseRequest.Entry(id=" + this.getId() + ", lat=" + this.getLat() + ", lon=" + this.getLon() + ", distance=" + this.getDistance() + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry other = (Entry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$distance = this.getDistance();
            Integer other$distance = other.getDistance();
            if (this$distance == null ? other$distance != null : !((Object)this$distance).equals(other$distance)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            BigDecimal this$lat = this.getLat();
            BigDecimal other$lat = other.getLat();
            if (this$lat == null ? other$lat != null : !((Object)this$lat).equals(other$lat)) {
                return false;
            }
            BigDecimal this$lon = this.getLon();
            BigDecimal other$lon = other.getLon();
            return !(this$lon == null ? other$lon != null : !((Object)this$lon).equals(other$lon));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Entry;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $distance = this.getDistance();
            result = result * 59 + ($distance == null ? 43 : ((Object)$distance).hashCode());
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            BigDecimal $lat = this.getLat();
            result = result * 59 + ($lat == null ? 43 : ((Object)$lat).hashCode());
            BigDecimal $lon = this.getLon();
            result = result * 59 + ($lon == null ? 43 : ((Object)$lon).hashCode());
            return result;
        }

        @Generated
        public static class EntryBuilder {
            @Generated
            private String id;
            @Generated
            private BigDecimal lat;
            @Generated
            private BigDecimal lon;
            @Generated
            private Integer distance;

            @Generated
            EntryBuilder() {
            }

            @Generated
            public EntryBuilder id(String id) {
                this.id = id;
                return this;
            }

            @Generated
            public EntryBuilder lat(BigDecimal lat) {
                this.lat = lat;
                return this;
            }

            @Generated
            public EntryBuilder lon(BigDecimal lon) {
                this.lon = lon;
                return this;
            }

            @Generated
            public EntryBuilder distance(Integer distance) {
                this.distance = distance;
                return this;
            }

            @Generated
            public Entry build() {
                return new Entry(this.id, this.lat, this.lon, this.distance);
            }

            @Generated
            public String toString() {
                return "ReverseRequest.Entry.EntryBuilder(id=" + this.id + ", lat=" + this.lat + ", lon=" + this.lon + ", distance=" + this.distance + ")";
            }
        }
    }
}

