/*
 * Decompiled with CFR 0.152.
 */
package global.maplink.geocode.schema.structured;

import global.maplink.env.Environment;
import global.maplink.geocode.schema.GeocodeSplittableRequest;
import global.maplink.geocode.schema.Type;
import global.maplink.http.request.Request;
import global.maplink.http.request.RequestBody;
import global.maplink.json.JsonMapper;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;

public interface StructuredRequest
extends GeocodeSplittableRequest {
    public static Single.SingleBuilder of(String id) {
        return Single.builder().id(id);
    }

    public static Single ofState(String id, String state) {
        return Single.builder().id(id).state(state).type(Type.STATE).build();
    }

    public static Single ofCity(String id, String city, String state) {
        return Single.builder().id(id).state(state).city(city).type(Type.CITY).build();
    }

    public static Single ofDistrict(String id, String district, String city, String state) {
        return Single.builder().id(id).state(state).city(city).district(district).type(Type.DISTRICT).build();
    }

    public static Multi multi(Single ... requests) {
        return new Multi(requests);
    }

    public static Multi multi(List<Single> requests) {
        return new Multi(requests.toArray(new Single[0]));
    }

    public static class Multi
    implements StructuredRequest {
        public static final String PATH = "geocode/v1/multi-geocode";
        public static final int REQ_LIMIT = 200;
        private final Single[] requests;

        public List<Multi> split() {
            if (this.requests.length < 200) {
                return Collections.singletonList(this);
            }
            int parts = this.requests.length / 200 + 1;
            List<Single> reqList = Arrays.asList(this.requests);
            return IntStream.range(0, parts).map(i -> i * 200).mapToObj(i -> reqList.subList(i, Math.min(i + 200, reqList.size()))).map(l -> l.toArray(new Single[0])).map(Multi::new).collect(Collectors.toList());
        }

        public Request asHttpRequest(Environment environment, JsonMapper mapper) {
            return Request.post((URL)environment.withService(PATH), (RequestBody)RequestBody.Json.of((Object)this.requests, (JsonMapper)mapper));
        }

        @Generated
        public Multi(Single[] requests) {
            this.requests = requests;
        }

        @Generated
        public Single[] getRequests() {
            return this.requests;
        }

        @Generated
        public String toString() {
            return "StructuredRequest.Multi(requests=" + Arrays.deepToString(this.getRequests()) + ")";
        }
    }

    public static class Single
    implements StructuredRequest {
        public static final String PATH = "geocode/v1/geocode";
        private String id;
        private String road;
        private Integer number;
        private String zipcode;
        private String district;
        private String city;
        private String state;
        private String acronym;
        private Type type;

        public List<Single> split() {
            return Collections.singletonList(this);
        }

        public Request asHttpRequest(Environment environment, JsonMapper mapper) {
            return Request.post((URL)environment.withService(PATH), (RequestBody)RequestBody.Json.of((Object)this, (JsonMapper)mapper));
        }

        @Generated
        Single(String id, String road, Integer number, String zipcode, String district, String city, String state, String acronym, Type type) {
            this.id = id;
            this.road = road;
            this.number = number;
            this.zipcode = zipcode;
            this.district = district;
            this.city = city;
            this.state = state;
            this.acronym = acronym;
            this.type = type;
        }

        @Generated
        public static SingleBuilder builder() {
            return new SingleBuilder();
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public String getRoad() {
            return this.road;
        }

        @Generated
        public Integer getNumber() {
            return this.number;
        }

        @Generated
        public String getZipcode() {
            return this.zipcode;
        }

        @Generated
        public String getDistrict() {
            return this.district;
        }

        @Generated
        public String getCity() {
            return this.city;
        }

        @Generated
        public String getState() {
            return this.state;
        }

        @Generated
        public String getAcronym() {
            return this.acronym;
        }

        @Generated
        public Type getType() {
            return this.type;
        }

        @Generated
        public String toString() {
            return "StructuredRequest.Single(id=" + this.getId() + ", road=" + this.getRoad() + ", number=" + this.getNumber() + ", zipcode=" + this.getZipcode() + ", district=" + this.getDistrict() + ", city=" + this.getCity() + ", state=" + this.getState() + ", acronym=" + this.getAcronym() + ", type=" + (Object)((Object)this.getType()) + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Single)) {
                return false;
            }
            Single other = (Single)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$number = this.getNumber();
            Integer other$number = other.getNumber();
            if (this$number == null ? other$number != null : !((Object)this$number).equals(other$number)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$road = this.getRoad();
            String other$road = other.getRoad();
            if (this$road == null ? other$road != null : !this$road.equals(other$road)) {
                return false;
            }
            String this$zipcode = this.getZipcode();
            String other$zipcode = other.getZipcode();
            if (this$zipcode == null ? other$zipcode != null : !this$zipcode.equals(other$zipcode)) {
                return false;
            }
            String this$district = this.getDistrict();
            String other$district = other.getDistrict();
            if (this$district == null ? other$district != null : !this$district.equals(other$district)) {
                return false;
            }
            String this$city = this.getCity();
            String other$city = other.getCity();
            if (this$city == null ? other$city != null : !this$city.equals(other$city)) {
                return false;
            }
            String this$state = this.getState();
            String other$state = other.getState();
            if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
                return false;
            }
            String this$acronym = this.getAcronym();
            String other$acronym = other.getAcronym();
            if (this$acronym == null ? other$acronym != null : !this$acronym.equals(other$acronym)) {
                return false;
            }
            Type this$type = this.getType();
            Type other$type = other.getType();
            return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Single;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $number = this.getNumber();
            result = result * 59 + ($number == null ? 43 : ((Object)$number).hashCode());
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $road = this.getRoad();
            result = result * 59 + ($road == null ? 43 : $road.hashCode());
            String $zipcode = this.getZipcode();
            result = result * 59 + ($zipcode == null ? 43 : $zipcode.hashCode());
            String $district = this.getDistrict();
            result = result * 59 + ($district == null ? 43 : $district.hashCode());
            String $city = this.getCity();
            result = result * 59 + ($city == null ? 43 : $city.hashCode());
            String $state = this.getState();
            result = result * 59 + ($state == null ? 43 : $state.hashCode());
            String $acronym = this.getAcronym();
            result = result * 59 + ($acronym == null ? 43 : $acronym.hashCode());
            Type $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            return result;
        }

        @Generated
        public static class SingleBuilder {
            @Generated
            private String id;
            @Generated
            private String road;
            @Generated
            private Integer number;
            @Generated
            private String zipcode;
            @Generated
            private String district;
            @Generated
            private String city;
            @Generated
            private String state;
            @Generated
            private String acronym;
            @Generated
            private Type type;

            @Generated
            SingleBuilder() {
            }

            @Generated
            public SingleBuilder id(String id) {
                this.id = id;
                return this;
            }

            @Generated
            public SingleBuilder road(String road) {
                this.road = road;
                return this;
            }

            @Generated
            public SingleBuilder number(Integer number) {
                this.number = number;
                return this;
            }

            @Generated
            public SingleBuilder zipcode(String zipcode) {
                this.zipcode = zipcode;
                return this;
            }

            @Generated
            public SingleBuilder district(String district) {
                this.district = district;
                return this;
            }

            @Generated
            public SingleBuilder city(String city) {
                this.city = city;
                return this;
            }

            @Generated
            public SingleBuilder state(String state) {
                this.state = state;
                return this;
            }

            @Generated
            public SingleBuilder acronym(String acronym) {
                this.acronym = acronym;
                return this;
            }

            @Generated
            public SingleBuilder type(Type type) {
                this.type = type;
                return this;
            }

            @Generated
            public Single build() {
                return new Single(this.id, this.road, this.number, this.zipcode, this.district, this.city, this.state, this.acronym, this.type);
            }

            @Generated
            public String toString() {
                return "StructuredRequest.Single.SingleBuilder(id=" + this.id + ", road=" + this.road + ", number=" + this.number + ", zipcode=" + this.zipcode + ", district=" + this.district + ", city=" + this.city + ", state=" + this.state + ", acronym=" + this.acronym + ", type=" + (Object)((Object)this.type) + ")";
            }
        }
    }
}

