/*
 * Decompiled with CFR 0.152.
 */
package global.maplink.geocode.schema.suggestions;

import global.maplink.geocode.schema.suggestions.Suggestion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import lombok.Generated;

public class SuggestionsResult
implements Iterable<Suggestion> {
    public static final SuggestionsResult EMPTY = new SuggestionsResult(0, Collections.emptyList());
    private final int found;
    private final List<Suggestion> results;

    public boolean isEmpty() {
        return this.results == null || this.results.isEmpty();
    }

    public Suggestion getMostRelevant() {
        if (this.isEmpty()) {
            return null;
        }
        return this.results.stream().max(Comparator.naturalOrder()).orElse(this.results.get(0));
    }

    public Optional<Suggestion> getById(String id) {
        Objects.requireNonNull(id);
        if (this.isEmpty()) {
            return Optional.empty();
        }
        return this.results.stream().filter(r -> id.equals(r.getId())).findAny();
    }

    public SuggestionsResult joinTo(SuggestionsResult anotherResult) {
        return new SuggestionsResult(this.found + anotherResult.found, Stream.concat(this.stream(), anotherResult.stream()).collect(Collectors.toList()));
    }

    @Override
    public Iterator<Suggestion> iterator() {
        if (this.isEmpty()) {
            return Collections.emptyIterator();
        }
        return this.results.iterator();
    }

    public Stream<Suggestion> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public Stream<Suggestion> parallelStream() {
        return StreamSupport.stream(this.spliterator(), true);
    }

    @Generated
    public static SuggestionsResultBuilder builder() {
        return new SuggestionsResultBuilder();
    }

    @Generated
    public int getFound() {
        return this.found;
    }

    @Generated
    public List<Suggestion> getResults() {
        return this.results;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SuggestionsResult)) {
            return false;
        }
        SuggestionsResult other = (SuggestionsResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getFound() != other.getFound()) {
            return false;
        }
        List<Suggestion> this$results = this.getResults();
        List<Suggestion> other$results = other.getResults();
        return !(this$results == null ? other$results != null : !((Object)this$results).equals(other$results));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SuggestionsResult;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getFound();
        List<Suggestion> $results = this.getResults();
        result = result * 59 + ($results == null ? 43 : ((Object)$results).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SuggestionsResult(found=" + this.getFound() + ", results=" + this.getResults() + ")";
    }

    @Generated
    public SuggestionsResult(int found, List<Suggestion> results) {
        this.found = found;
        this.results = results;
    }

    @Generated
    public SuggestionsResult() {
        this.found = 0;
        this.results = null;
    }

    @Generated
    public static class SuggestionsResultBuilder {
        @Generated
        private int found;
        @Generated
        private ArrayList<Suggestion> results;

        @Generated
        SuggestionsResultBuilder() {
        }

        @Generated
        public SuggestionsResultBuilder found(int found) {
            this.found = found;
            return this;
        }

        @Generated
        public SuggestionsResultBuilder result(Suggestion result) {
            if (this.results == null) {
                this.results = new ArrayList();
            }
            this.results.add(result);
            return this;
        }

        @Generated
        public SuggestionsResultBuilder results(Collection<? extends Suggestion> results) {
            if (results == null) {
                throw new NullPointerException("results cannot be null");
            }
            if (this.results == null) {
                this.results = new ArrayList();
            }
            this.results.addAll(results);
            return this;
        }

        @Generated
        public SuggestionsResultBuilder clearResults() {
            if (this.results != null) {
                this.results.clear();
            }
            return this;
        }

        @Generated
        public SuggestionsResult build() {
            List<Suggestion> results;
            switch (this.results == null ? 0 : this.results.size()) {
                case 0: {
                    results = Collections.emptyList();
                    break;
                }
                case 1: {
                    results = Collections.singletonList(this.results.get(0));
                    break;
                }
                default: {
                    results = Collections.unmodifiableList(new ArrayList<Suggestion>(this.results));
                }
            }
            return new SuggestionsResult(this.found, results);
        }

        @Generated
        public String toString() {
            return "SuggestionsResult.SuggestionsResultBuilder(found=" + this.found + ", results=" + this.results + ")";
        }
    }
}

