/*
 * Decompiled with CFR 0.152.
 */
package global.maplink.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import global.maplink.json.JsonException;
import global.maplink.json.JsonMapper;
import global.maplink.json.MaplinkSdkModule;
import java.io.IOException;
import java.util.List;

public class JacksonJsonMapperImpl
implements JsonMapper {
    private final ObjectMapper mapper = new ObjectMapper().registerModule((Module)new JavaTimeModule()).registerModule((Module)new MaplinkSdkModule()).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);

    public <T> T fromJson(byte[] data, Class<T> type) {
        try {
            return (T)this.mapper.readValue(data, type);
        }
        catch (IOException e) {
            throw new JsonException((Exception)e);
        }
    }

    public <T> List<T> fromJsonList(byte[] data, Class<T> type) {
        try {
            CollectionType collectionType = this.mapper.getTypeFactory().constructCollectionType(List.class, type);
            return (List)this.mapper.readValue(data, (JavaType)collectionType);
        }
        catch (IOException e) {
            throw new JsonException((Exception)e);
        }
    }

    public <T> byte[] toJson(T object) {
        try {
            return this.mapper.writeValueAsBytes(object);
        }
        catch (JsonProcessingException e) {
            throw new JsonException((Exception)((Object)e));
        }
    }
}

