/*
 * Decompiled with CFR 0.152.
 */
package global.maplink.json.codecs;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import global.maplink.domain.MaplinkPoint;
import global.maplink.domain.PointsMode;
import global.maplink.json.codecs.MlpJacksonCodec;
import java.io.IOException;
import java.util.Locale;

public class MaplinkPointJacksonCodec
extends MlpJacksonCodec<MaplinkPoint> {
    public static final String FIELD_LATITUDE = "latitude";
    public static final String FIELD_LONGITUDE = "longitude";
    public static final String FIELD_POINT = "point";

    public MaplinkPointJacksonCodec() {
        super(MaplinkPoint.class, new Serializer(), new Deserializer());
    }

    public static class Deserializer
    extends JsonDeserializer<MaplinkPoint> {
        public MaplinkPoint deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            switch (parser.currentToken()) {
                case VALUE_STRING: {
                    return this.deserializeGeohash(parser);
                }
                case START_ARRAY: {
                    return this.deserializeArray(parser);
                }
                case START_OBJECT: {
                    return this.deserializeObjectOrSimple(parser);
                }
            }
            return null;
        }

        private MaplinkPoint deserializeArray(JsonParser parser) throws IOException {
            double[] coordinates = (double[])parser.readValueAs(double[].class);
            return MaplinkPoint.from((double[])coordinates);
        }

        private MaplinkPoint deserializeGeohash(JsonParser parser) throws IOException {
            String coordinates = (String)parser.readValueAs(String.class);
            return MaplinkPoint.fromGeohash((String)coordinates);
        }

        private MaplinkPoint deserializeObjectOrSimple(JsonParser parser) throws IOException {
            JsonNode node = (JsonNode)parser.readValueAsTree();
            if (node.has(MaplinkPointJacksonCodec.FIELD_POINT)) {
                String value = node.get(MaplinkPointJacksonCodec.FIELD_POINT).asText();
                String[] coordinates = value.split(",");
                if (coordinates.length != 2) {
                    throw new IllegalArgumentException("Invalid point format [" + value + "], expected [lat,long]");
                }
                return new MaplinkPoint(Double.parseDouble(coordinates[0]), Double.parseDouble(coordinates[1]));
            }
            return new MaplinkPoint(node.get(MaplinkPointJacksonCodec.FIELD_LATITUDE).asDouble(), node.get(MaplinkPointJacksonCodec.FIELD_LONGITUDE).asDouble());
        }
    }

    public static class Serializer
    extends JsonSerializer<MaplinkPoint> {
        public void serialize(MaplinkPoint value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            switch (PointsMode.current()) {
                case SIMPLE: {
                    this.serializeAsSimple(value, jgen);
                    break;
                }
                case ARRAY: {
                    this.serializeAsArray(value, jgen);
                    break;
                }
                case GEOHASH: {
                    this.serializeAsGeohash(value, jgen);
                    break;
                }
                case OBJECT: 
                case POLYLINE: {
                    this.serializeAsObject(value, jgen);
                }
            }
        }

        private void serializeAsSimple(MaplinkPoint value, JsonGenerator jgen) throws IOException {
            jgen.writeStartObject();
            jgen.writeStringField(MaplinkPointJacksonCodec.FIELD_POINT, String.format(Locale.ENGLISH, "%.7f,%7f", value.getLatitude(), value.getLongitude()));
            jgen.writeEndObject();
        }

        private void serializeAsObject(MaplinkPoint value, JsonGenerator jgen) throws IOException {
            jgen.writeStartObject();
            jgen.writeNumberField(MaplinkPointJacksonCodec.FIELD_LATITUDE, value.getLatitude());
            jgen.writeNumberField(MaplinkPointJacksonCodec.FIELD_LONGITUDE, value.getLongitude());
            jgen.writeEndObject();
        }

        private void serializeAsGeohash(MaplinkPoint value, JsonGenerator jgen) throws IOException {
            jgen.writeString(value.toGeohash());
        }

        private void serializeAsArray(MaplinkPoint value, JsonGenerator jgen) throws IOException {
            double[] coordinates = value.toArray();
            jgen.writeArray(coordinates, 0, coordinates.length);
        }
    }
}

