/*
 * Decompiled with CFR 0.152.
 */
package global.maplink.json.codecs;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import global.maplink.domain.MaplinkPoint;
import global.maplink.domain.MaplinkPoints;
import global.maplink.domain.PointsMode;
import global.maplink.json.codecs.MlpJacksonCodec;
import java.io.IOException;
import java.util.Objects;

public class MaplinkPointsJacksonCodec
extends MlpJacksonCodec<MaplinkPoints> {
    public MaplinkPointsJacksonCodec() {
        super(MaplinkPoints.class, new Serializer(), new Deserializer());
    }

    public static class Deserializer
    extends JsonDeserializer<MaplinkPoints> {
        public MaplinkPoints deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            switch (parser.currentToken()) {
                case VALUE_STRING: {
                    return this.deserializePolyline(parser);
                }
                case START_ARRAY: {
                    return this.deserializeArray(parser);
                }
            }
            return null;
        }

        private MaplinkPoints deserializePolyline(JsonParser parser) throws IOException {
            return MaplinkPoints.fromPolyline((String)((String)parser.readValueAs(String.class)));
        }

        private MaplinkPoints deserializeArray(JsonParser parser) throws IOException {
            MaplinkPoint[] points = (MaplinkPoint[])parser.readValueAs(MaplinkPoint[].class);
            if (Objects.isNull(points) || points.length < 1) {
                return MaplinkPoints.EMPTY;
            }
            return new MaplinkPoints(points);
        }
    }

    public static class Serializer
    extends JsonSerializer<MaplinkPoints> {
        public void serialize(MaplinkPoints value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            switch (PointsMode.current()) {
                case SIMPLE: 
                case OBJECT: 
                case ARRAY: 
                case GEOHASH: {
                    this.serializeAsList(value, jgen);
                    break;
                }
                case POLYLINE: {
                    this.serializeAsPolyline(value, jgen);
                }
            }
        }

        private void serializeAsList(MaplinkPoints value, JsonGenerator jgen) throws IOException {
            jgen.writeStartArray();
            for (MaplinkPoint point : value) {
                jgen.writePOJO((Object)point);
            }
            jgen.writeEndArray();
        }

        private void serializeAsPolyline(MaplinkPoints value, JsonGenerator jgen) throws IOException {
            jgen.writeString(value.toPolyline());
        }
    }
}

