/*
 * Decompiled with CFR 0.152.
 */
package global.maplink.place.schema;

import global.maplink.place.schema.Point;
import global.maplink.place.schema.exception.PlaceUpdateViolation;
import global.maplink.validations.Validable;
import global.maplink.validations.ValidationViolation;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;

public class Address
implements Validable {
    private final String street;
    private final String number;
    private final String district;
    private final String city;
    private final String state;
    private final String zipcode;
    private final String complement;
    private final Point point;

    public List<ValidationViolation> validate() {
        LinkedList<ValidationViolation> violations = new LinkedList<ValidationViolation>();
        if (this.isInvalid(this.street)) {
            violations.add(PlaceUpdateViolation.of("address.street"));
        }
        if (this.isInvalid(this.city)) {
            violations.add(PlaceUpdateViolation.of("address.city"));
        }
        if (this.isInvalid(this.state)) {
            violations.add(PlaceUpdateViolation.of("address.state"));
        }
        if (this.isInvalid(this.number)) {
            violations.add(PlaceUpdateViolation.of("address.number"));
        }
        if (this.isInvalid(this.zipcode)) {
            violations.add(PlaceUpdateViolation.of("address.zipcode"));
        }
        if (Objects.isNull(this.point)) {
            violations.add(PlaceUpdateViolation.of("address.point"));
        }
        return violations;
    }

    private boolean isInvalid(String value) {
        return Objects.isNull(value) || value.trim().isEmpty();
    }

    @Generated
    public static AddressBuilder builder() {
        return new AddressBuilder();
    }

    @Generated
    public String getStreet() {
        return this.street;
    }

    @Generated
    public String getNumber() {
        return this.number;
    }

    @Generated
    public String getDistrict() {
        return this.district;
    }

    @Generated
    public String getCity() {
        return this.city;
    }

    @Generated
    public String getState() {
        return this.state;
    }

    @Generated
    public String getZipcode() {
        return this.zipcode;
    }

    @Generated
    public String getComplement() {
        return this.complement;
    }

    @Generated
    public Point getPoint() {
        return this.point;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Address)) {
            return false;
        }
        Address other = (Address)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$street = this.getStreet();
        String other$street = other.getStreet();
        if (this$street == null ? other$street != null : !this$street.equals(other$street)) {
            return false;
        }
        String this$number = this.getNumber();
        String other$number = other.getNumber();
        if (this$number == null ? other$number != null : !this$number.equals(other$number)) {
            return false;
        }
        String this$district = this.getDistrict();
        String other$district = other.getDistrict();
        if (this$district == null ? other$district != null : !this$district.equals(other$district)) {
            return false;
        }
        String this$city = this.getCity();
        String other$city = other.getCity();
        if (this$city == null ? other$city != null : !this$city.equals(other$city)) {
            return false;
        }
        String this$state = this.getState();
        String other$state = other.getState();
        if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
            return false;
        }
        String this$zipcode = this.getZipcode();
        String other$zipcode = other.getZipcode();
        if (this$zipcode == null ? other$zipcode != null : !this$zipcode.equals(other$zipcode)) {
            return false;
        }
        String this$complement = this.getComplement();
        String other$complement = other.getComplement();
        if (this$complement == null ? other$complement != null : !this$complement.equals(other$complement)) {
            return false;
        }
        Point this$point = this.getPoint();
        Point other$point = other.getPoint();
        return !(this$point == null ? other$point != null : !((Object)this$point).equals(other$point));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Address;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $street = this.getStreet();
        result = result * 59 + ($street == null ? 43 : $street.hashCode());
        String $number = this.getNumber();
        result = result * 59 + ($number == null ? 43 : $number.hashCode());
        String $district = this.getDistrict();
        result = result * 59 + ($district == null ? 43 : $district.hashCode());
        String $city = this.getCity();
        result = result * 59 + ($city == null ? 43 : $city.hashCode());
        String $state = this.getState();
        result = result * 59 + ($state == null ? 43 : $state.hashCode());
        String $zipcode = this.getZipcode();
        result = result * 59 + ($zipcode == null ? 43 : $zipcode.hashCode());
        String $complement = this.getComplement();
        result = result * 59 + ($complement == null ? 43 : $complement.hashCode());
        Point $point = this.getPoint();
        result = result * 59 + ($point == null ? 43 : ((Object)$point).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Address(street=" + this.getStreet() + ", number=" + this.getNumber() + ", district=" + this.getDistrict() + ", city=" + this.getCity() + ", state=" + this.getState() + ", zipcode=" + this.getZipcode() + ", complement=" + this.getComplement() + ", point=" + this.getPoint() + ")";
    }

    @Generated
    public Address(String street, String number, String district, String city, String state, String zipcode, String complement, Point point) {
        this.street = street;
        this.number = number;
        this.district = district;
        this.city = city;
        this.state = state;
        this.zipcode = zipcode;
        this.complement = complement;
        this.point = point;
    }

    @Generated
    private Address() {
        this.street = null;
        this.number = null;
        this.district = null;
        this.city = null;
        this.state = null;
        this.zipcode = null;
        this.complement = null;
        this.point = null;
    }

    @Generated
    public static class AddressBuilder {
        @Generated
        private String street;
        @Generated
        private String number;
        @Generated
        private String district;
        @Generated
        private String city;
        @Generated
        private String state;
        @Generated
        private String zipcode;
        @Generated
        private String complement;
        @Generated
        private Point point;

        @Generated
        AddressBuilder() {
        }

        @Generated
        public AddressBuilder street(String street) {
            this.street = street;
            return this;
        }

        @Generated
        public AddressBuilder number(String number) {
            this.number = number;
            return this;
        }

        @Generated
        public AddressBuilder district(String district) {
            this.district = district;
            return this;
        }

        @Generated
        public AddressBuilder city(String city) {
            this.city = city;
            return this;
        }

        @Generated
        public AddressBuilder state(String state) {
            this.state = state;
            return this;
        }

        @Generated
        public AddressBuilder zipcode(String zipcode) {
            this.zipcode = zipcode;
            return this;
        }

        @Generated
        public AddressBuilder complement(String complement) {
            this.complement = complement;
            return this;
        }

        @Generated
        public AddressBuilder point(Point point) {
            this.point = point;
            return this;
        }

        @Generated
        public Address build() {
            return new Address(this.street, this.number, this.district, this.city, this.state, this.zipcode, this.complement, this.point);
        }

        @Generated
        public String toString() {
            return "Address.AddressBuilder(street=" + this.street + ", number=" + this.number + ", district=" + this.district + ", city=" + this.city + ", state=" + this.state + ", zipcode=" + this.zipcode + ", complement=" + this.complement + ", point=" + this.point + ")";
        }
    }
}

