/*
 * Decompiled with CFR 0.152.
 */
package global.maplink.place.schema;

import global.maplink.place.schema.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;

public class Leg {
    private final List<Point> points;

    public static Leg of(double latitude, double longitude, double ... points) {
        if (points.length % 2 != 0) {
            throw new IllegalArgumentException("Leg.points requires pairs of lat long");
        }
        ArrayList<Point> list = new ArrayList<Point>(points.length / 2);
        list.add(Point.of(latitude, longitude));
        for (int i = 0; i < points.length; i += 2) {
            list.add(Point.of(points[i], points[i + 1]));
        }
        return new Leg(list);
    }

    @Generated
    public static LegBuilder builder() {
        return new LegBuilder();
    }

    @Generated
    public List<Point> getPoints() {
        return this.points;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Leg)) {
            return false;
        }
        Leg other = (Leg)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Point> this$points = this.getPoints();
        List<Point> other$points = other.getPoints();
        return !(this$points == null ? other$points != null : !((Object)this$points).equals(other$points));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Leg;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Point> $points = this.getPoints();
        result = result * 59 + ($points == null ? 43 : ((Object)$points).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Leg(points=" + this.getPoints() + ")";
    }

    @Generated
    public Leg(List<Point> points) {
        this.points = points;
    }

    @Generated
    private Leg() {
        this.points = null;
    }

    @Generated
    public static class LegBuilder {
        @Generated
        private ArrayList<Point> points;

        @Generated
        LegBuilder() {
        }

        @Generated
        public LegBuilder point(Point point) {
            if (this.points == null) {
                this.points = new ArrayList();
            }
            this.points.add(point);
            return this;
        }

        @Generated
        public LegBuilder points(Collection<? extends Point> points) {
            if (points == null) {
                throw new NullPointerException("points cannot be null");
            }
            if (this.points == null) {
                this.points = new ArrayList();
            }
            this.points.addAll(points);
            return this;
        }

        @Generated
        public LegBuilder clearPoints() {
            if (this.points != null) {
                this.points.clear();
            }
            return this;
        }

        @Generated
        public Leg build() {
            List<Point> points;
            switch (this.points == null ? 0 : this.points.size()) {
                case 0: {
                    points = Collections.emptyList();
                    break;
                }
                case 1: {
                    points = Collections.singletonList(this.points.get(0));
                    break;
                }
                default: {
                    points = Collections.unmodifiableList(new ArrayList<Point>(this.points));
                }
            }
            return new Leg(points);
        }

        @Generated
        public String toString() {
            return "Leg.LegBuilder(points=" + this.points + ")";
        }
    }
}

