/*
 * Decompiled with CFR 0.152.
 */
package global.maplink.place.schema;

import global.maplink.place.schema.Address;
import global.maplink.place.schema.Category;
import global.maplink.place.schema.OpeningHours;
import global.maplink.place.schema.PaymentMethod;
import global.maplink.place.schema.SocialConnection;
import global.maplink.place.schema.SubCategory;
import global.maplink.place.schema.exception.PlaceUpdateViolation;
import global.maplink.validations.Validable;
import global.maplink.validations.ValidationViolation;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;

public class Place
implements Validable {
    private final String id;
    private final String name;
    private final String documentNumber;
    private final String description;
    private final String url;
    private final String website;
    private final String favicon;
    private final OpeningHours openingHours;
    private final Set<PaymentMethod> payments;
    private final Category category;
    private final SubCategory subCategory;
    private final Address address;
    private final Set<String> phones;
    private final Map<String, String> additionalInfo;
    private final Set<SocialConnection> connections;
    private final Set<String> tags;
    private final boolean active;
    private final String clientId;

    public List<ValidationViolation> validate() {
        LinkedList<ValidationViolation> violations = new LinkedList<ValidationViolation>();
        if (this.isInvalid(this.id)) {
            violations.add(PlaceUpdateViolation.of("id"));
        }
        if (this.isInvalid(this.name)) {
            violations.add(PlaceUpdateViolation.of("name"));
        }
        if (Objects.isNull((Object)this.category)) {
            violations.add(PlaceUpdateViolation.of("category"));
        }
        if (Objects.isNull((Object)this.subCategory)) {
            violations.add(PlaceUpdateViolation.of("subCategory"));
        }
        if (Objects.isNull(this.address)) {
            violations.add(PlaceUpdateViolation.of("subCategory"));
        } else {
            violations.addAll(this.address.validate());
        }
        return violations;
    }

    private boolean isInvalid(String value) {
        return Objects.isNull(value) || value.trim().isEmpty();
    }

    @Generated
    public static PlaceBuilder builder() {
        return new PlaceBuilder();
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDocumentNumber() {
        return this.documentNumber;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public String getWebsite() {
        return this.website;
    }

    @Generated
    public String getFavicon() {
        return this.favicon;
    }

    @Generated
    public OpeningHours getOpeningHours() {
        return this.openingHours;
    }

    @Generated
    public Set<PaymentMethod> getPayments() {
        return this.payments;
    }

    @Generated
    public Category getCategory() {
        return this.category;
    }

    @Generated
    public SubCategory getSubCategory() {
        return this.subCategory;
    }

    @Generated
    public Address getAddress() {
        return this.address;
    }

    @Generated
    public Set<String> getPhones() {
        return this.phones;
    }

    @Generated
    public Map<String, String> getAdditionalInfo() {
        return this.additionalInfo;
    }

    @Generated
    public Set<SocialConnection> getConnections() {
        return this.connections;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }

    @Generated
    public boolean isActive() {
        return this.active;
    }

    @Generated
    public String getClientId() {
        return this.clientId;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Place)) {
            return false;
        }
        Place other = (Place)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isActive() != other.isActive()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$documentNumber = this.getDocumentNumber();
        String other$documentNumber = other.getDocumentNumber();
        if (this$documentNumber == null ? other$documentNumber != null : !this$documentNumber.equals(other$documentNumber)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$website = this.getWebsite();
        String other$website = other.getWebsite();
        if (this$website == null ? other$website != null : !this$website.equals(other$website)) {
            return false;
        }
        String this$favicon = this.getFavicon();
        String other$favicon = other.getFavicon();
        if (this$favicon == null ? other$favicon != null : !this$favicon.equals(other$favicon)) {
            return false;
        }
        OpeningHours this$openingHours = this.getOpeningHours();
        OpeningHours other$openingHours = other.getOpeningHours();
        if (this$openingHours == null ? other$openingHours != null : !((Object)this$openingHours).equals(other$openingHours)) {
            return false;
        }
        Set<PaymentMethod> this$payments = this.getPayments();
        Set<PaymentMethod> other$payments = other.getPayments();
        if (this$payments == null ? other$payments != null : !((Object)this$payments).equals(other$payments)) {
            return false;
        }
        Category this$category = this.getCategory();
        Category other$category = other.getCategory();
        if (this$category == null ? other$category != null : !((Object)((Object)this$category)).equals((Object)other$category)) {
            return false;
        }
        SubCategory this$subCategory = this.getSubCategory();
        SubCategory other$subCategory = other.getSubCategory();
        if (this$subCategory == null ? other$subCategory != null : !((Object)((Object)this$subCategory)).equals((Object)other$subCategory)) {
            return false;
        }
        Address this$address = this.getAddress();
        Address other$address = other.getAddress();
        if (this$address == null ? other$address != null : !((Object)this$address).equals(other$address)) {
            return false;
        }
        Set<String> this$phones = this.getPhones();
        Set<String> other$phones = other.getPhones();
        if (this$phones == null ? other$phones != null : !((Object)this$phones).equals(other$phones)) {
            return false;
        }
        Map<String, String> this$additionalInfo = this.getAdditionalInfo();
        Map<String, String> other$additionalInfo = other.getAdditionalInfo();
        if (this$additionalInfo == null ? other$additionalInfo != null : !((Object)this$additionalInfo).equals(other$additionalInfo)) {
            return false;
        }
        Set<SocialConnection> this$connections = this.getConnections();
        Set<SocialConnection> other$connections = other.getConnections();
        if (this$connections == null ? other$connections != null : !((Object)this$connections).equals(other$connections)) {
            return false;
        }
        Set<String> this$tags = this.getTags();
        Set<String> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        String this$clientId = this.getClientId();
        String other$clientId = other.getClientId();
        return !(this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Place;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isActive() ? 79 : 97);
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $documentNumber = this.getDocumentNumber();
        result = result * 59 + ($documentNumber == null ? 43 : $documentNumber.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $website = this.getWebsite();
        result = result * 59 + ($website == null ? 43 : $website.hashCode());
        String $favicon = this.getFavicon();
        result = result * 59 + ($favicon == null ? 43 : $favicon.hashCode());
        OpeningHours $openingHours = this.getOpeningHours();
        result = result * 59 + ($openingHours == null ? 43 : ((Object)$openingHours).hashCode());
        Set<PaymentMethod> $payments = this.getPayments();
        result = result * 59 + ($payments == null ? 43 : ((Object)$payments).hashCode());
        Category $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : ((Object)((Object)$category)).hashCode());
        SubCategory $subCategory = this.getSubCategory();
        result = result * 59 + ($subCategory == null ? 43 : ((Object)((Object)$subCategory)).hashCode());
        Address $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
        Set<String> $phones = this.getPhones();
        result = result * 59 + ($phones == null ? 43 : ((Object)$phones).hashCode());
        Map<String, String> $additionalInfo = this.getAdditionalInfo();
        result = result * 59 + ($additionalInfo == null ? 43 : ((Object)$additionalInfo).hashCode());
        Set<SocialConnection> $connections = this.getConnections();
        result = result * 59 + ($connections == null ? 43 : ((Object)$connections).hashCode());
        Set<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        String $clientId = this.getClientId();
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Place(id=" + this.getId() + ", name=" + this.getName() + ", documentNumber=" + this.getDocumentNumber() + ", description=" + this.getDescription() + ", url=" + this.getUrl() + ", website=" + this.getWebsite() + ", favicon=" + this.getFavicon() + ", openingHours=" + this.getOpeningHours() + ", payments=" + this.getPayments() + ", category=" + (Object)((Object)this.getCategory()) + ", subCategory=" + (Object)((Object)this.getSubCategory()) + ", address=" + this.getAddress() + ", phones=" + this.getPhones() + ", additionalInfo=" + this.getAdditionalInfo() + ", connections=" + this.getConnections() + ", tags=" + this.getTags() + ", active=" + this.isActive() + ", clientId=" + this.getClientId() + ")";
    }

    @Generated
    private Place(String id, String name, String documentNumber, String description, String url, String website, String favicon, OpeningHours openingHours, Set<PaymentMethod> payments, Category category, SubCategory subCategory, Address address, Set<String> phones, Map<String, String> additionalInfo, Set<SocialConnection> connections, Set<String> tags, boolean active, String clientId) {
        this.id = id;
        this.name = name;
        this.documentNumber = documentNumber;
        this.description = description;
        this.url = url;
        this.website = website;
        this.favicon = favicon;
        this.openingHours = openingHours;
        this.payments = payments;
        this.category = category;
        this.subCategory = subCategory;
        this.address = address;
        this.phones = phones;
        this.additionalInfo = additionalInfo;
        this.connections = connections;
        this.tags = tags;
        this.active = active;
        this.clientId = clientId;
    }

    @Generated
    public static Place of(String id, String name, String documentNumber, String description, String url, String website, String favicon, OpeningHours openingHours, Set<PaymentMethod> payments, Category category, SubCategory subCategory, Address address, Set<String> phones, Map<String, String> additionalInfo, Set<SocialConnection> connections, Set<String> tags, boolean active, String clientId) {
        return new Place(id, name, documentNumber, description, url, website, favicon, openingHours, payments, category, subCategory, address, phones, additionalInfo, connections, tags, active, clientId);
    }

    @Generated
    private Place() {
        this.id = null;
        this.name = null;
        this.documentNumber = null;
        this.description = null;
        this.url = null;
        this.website = null;
        this.favicon = null;
        this.openingHours = null;
        this.payments = null;
        this.category = null;
        this.subCategory = null;
        this.address = null;
        this.phones = null;
        this.additionalInfo = null;
        this.connections = null;
        this.tags = null;
        this.active = false;
        this.clientId = null;
    }

    @Generated
    public static class PlaceBuilder {
        @Generated
        private String id;
        @Generated
        private String name;
        @Generated
        private String documentNumber;
        @Generated
        private String description;
        @Generated
        private String url;
        @Generated
        private String website;
        @Generated
        private String favicon;
        @Generated
        private OpeningHours openingHours;
        @Generated
        private Set<PaymentMethod> payments;
        @Generated
        private Category category;
        @Generated
        private SubCategory subCategory;
        @Generated
        private Address address;
        @Generated
        private Set<String> phones;
        @Generated
        private Map<String, String> additionalInfo;
        @Generated
        private Set<SocialConnection> connections;
        @Generated
        private Set<String> tags;
        @Generated
        private boolean active;
        @Generated
        private String clientId;

        @Generated
        PlaceBuilder() {
        }

        @Generated
        public PlaceBuilder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public PlaceBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public PlaceBuilder documentNumber(String documentNumber) {
            this.documentNumber = documentNumber;
            return this;
        }

        @Generated
        public PlaceBuilder description(String description) {
            this.description = description;
            return this;
        }

        @Generated
        public PlaceBuilder url(String url) {
            this.url = url;
            return this;
        }

        @Generated
        public PlaceBuilder website(String website) {
            this.website = website;
            return this;
        }

        @Generated
        public PlaceBuilder favicon(String favicon) {
            this.favicon = favicon;
            return this;
        }

        @Generated
        public PlaceBuilder openingHours(OpeningHours openingHours) {
            this.openingHours = openingHours;
            return this;
        }

        @Generated
        public PlaceBuilder payments(Set<PaymentMethod> payments) {
            this.payments = payments;
            return this;
        }

        @Generated
        public PlaceBuilder category(Category category) {
            this.category = category;
            return this;
        }

        @Generated
        public PlaceBuilder subCategory(SubCategory subCategory) {
            this.subCategory = subCategory;
            return this;
        }

        @Generated
        public PlaceBuilder address(Address address) {
            this.address = address;
            return this;
        }

        @Generated
        public PlaceBuilder phones(Set<String> phones) {
            this.phones = phones;
            return this;
        }

        @Generated
        public PlaceBuilder additionalInfo(Map<String, String> additionalInfo) {
            this.additionalInfo = additionalInfo;
            return this;
        }

        @Generated
        public PlaceBuilder connections(Set<SocialConnection> connections) {
            this.connections = connections;
            return this;
        }

        @Generated
        public PlaceBuilder tags(Set<String> tags) {
            this.tags = tags;
            return this;
        }

        @Generated
        public PlaceBuilder active(boolean active) {
            this.active = active;
            return this;
        }

        @Generated
        public PlaceBuilder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        @Generated
        public Place build() {
            return new Place(this.id, this.name, this.documentNumber, this.description, this.url, this.website, this.favicon, this.openingHours, this.payments, this.category, this.subCategory, this.address, this.phones, this.additionalInfo, this.connections, this.tags, this.active, this.clientId);
        }

        @Generated
        public String toString() {
            return "Place.PlaceBuilder(id=" + this.id + ", name=" + this.name + ", documentNumber=" + this.documentNumber + ", description=" + this.description + ", url=" + this.url + ", website=" + this.website + ", favicon=" + this.favicon + ", openingHours=" + this.openingHours + ", payments=" + this.payments + ", category=" + (Object)((Object)this.category) + ", subCategory=" + (Object)((Object)this.subCategory) + ", address=" + this.address + ", phones=" + this.phones + ", additionalInfo=" + this.additionalInfo + ", connections=" + this.connections + ", tags=" + this.tags + ", active=" + this.active + ", clientId=" + this.clientId + ")";
        }
    }
}

