/*
 * Decompiled with CFR 0.152.
 */
package global.maplink.place.schema;

import global.maplink.MapLinkServiceRequest;
import global.maplink.env.Environment;
import global.maplink.http.Response;
import global.maplink.http.request.Request;
import global.maplink.json.JsonMapper;
import global.maplink.place.schema.Place;
import global.maplink.place.schema.exception.PlaceErrorType;
import global.maplink.validations.Validable;
import global.maplink.validations.ValidationViolation;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import lombok.Generated;

public class PlaceByOriginIdRequest
implements MapLinkServiceRequest<Optional<Place>>,
Validable {
    public static final String PATH = "place/v1/places/%s";
    private static final int NO_CONTENT = 204;
    private final String originId;

    public Request asHttpRequest(Environment environment, JsonMapper mapper) {
        this.throwIfInvalid();
        return Request.get((URL)environment.withService(String.format(PATH, this.originId)));
    }

    public Function<Response, Optional<Place>> getResponseParser(JsonMapper mapper) {
        return response -> {
            if (response.getStatusCode() == 204) {
                return Optional.empty();
            }
            return Optional.of((Place)response.parseBodyObject(mapper, Place.class));
        };
    }

    public List<ValidationViolation> validate() {
        if (this.originId == null || this.originId.trim().isEmpty()) {
            return Collections.singletonList(PlaceErrorType.REQUIRED_FIELDS_INVALID);
        }
        return Collections.emptyList();
    }

    @Generated
    public static PlaceByOriginIdRequestBuilder builder() {
        return new PlaceByOriginIdRequestBuilder();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PlaceByOriginIdRequest)) {
            return false;
        }
        PlaceByOriginIdRequest other = (PlaceByOriginIdRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$originId = this.originId;
        String other$originId = other.originId;
        return !(this$originId == null ? other$originId != null : !this$originId.equals(other$originId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PlaceByOriginIdRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $originId = this.originId;
        result = result * 59 + ($originId == null ? 43 : $originId.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PlaceByOriginIdRequest(originId=" + this.originId + ")";
    }

    @Generated
    public PlaceByOriginIdRequest(String originId) {
        this.originId = originId;
    }

    @Generated
    public PlaceByOriginIdRequest() {
        this.originId = null;
    }

    @Generated
    public static class PlaceByOriginIdRequestBuilder {
        @Generated
        private String originId;

        @Generated
        PlaceByOriginIdRequestBuilder() {
        }

        @Generated
        public PlaceByOriginIdRequestBuilder originId(String originId) {
            this.originId = originId;
            return this;
        }

        @Generated
        public PlaceByOriginIdRequest build() {
            return new PlaceByOriginIdRequest(this.originId);
        }

        @Generated
        public String toString() {
            return "PlaceByOriginIdRequest.PlaceByOriginIdRequestBuilder(originId=" + this.originId + ")";
        }
    }
}

