/*
 * Decompiled with CFR 0.152.
 */
package global.maplink.place.schema;

import global.maplink.MapLinkServiceRequest;
import global.maplink.env.Environment;
import global.maplink.http.Response;
import global.maplink.http.request.Request;
import global.maplink.http.request.RequestBody;
import global.maplink.json.JsonMapper;
import global.maplink.place.schema.Category;
import global.maplink.place.schema.Leg;
import global.maplink.place.schema.PlaceRouteResponse;
import global.maplink.place.schema.SubCategory;
import global.maplink.place.schema.exception.PlaceCalculationRequestException;
import global.maplink.place.schema.exception.PlaceErrorType;
import global.maplink.validations.ValidationViolation;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import lombok.Generated;

public class PlaceRouteRequest
implements MapLinkServiceRequest<PlaceRouteResponse> {
    public static final String PATH = "place/v1/calculations";
    public static final int MAX_BUFFER = 500;
    private final Set<Category> categories;
    private final Set<SubCategory> subCategories;
    private final Long bufferRouteInMeters;
    private final Long bufferStoppingPointsInMeters;
    private final boolean onlyMyPlaces;
    private final List<Leg> legs;

    public List<ValidationViolation> validate() {
        ArrayList<ValidationViolation> errors = new ArrayList<ValidationViolation>();
        if (Objects.isNull(this.bufferRouteInMeters) || this.bufferRouteInMeters <= 0L) {
            errors.add(PlaceErrorType.ROUTE_BUFFER_LESS_THAN_ZERO);
        } else if (this.bufferRouteInMeters > 500L) {
            errors.add(PlaceErrorType.ROUTE_BUFFER_BIGGER_THAN_MAX_BUFFER);
        }
        if (Objects.isNull(this.bufferStoppingPointsInMeters) || this.bufferStoppingPointsInMeters <= 0L) {
            errors.add(PlaceErrorType.STOPPING_POINTS_LESS_THAN_ZERO);
        } else if (this.bufferStoppingPointsInMeters > 500L) {
            errors.add(PlaceErrorType.STOPPING_POINTS_BIGGER_THAN_MAX_BUFFER);
        }
        if (!this.containsCategory() && !this.containsSubCategory()) {
            errors.add(PlaceErrorType.CATEGORY_SUBCATEGORY_NECESSARY);
        }
        return errors;
    }

    public void validateWithLegs() {
        this.throwIfInvalid();
        if (this.getLegs() == null || this.getLegs().isEmpty()) {
            throw new PlaceCalculationRequestException(PlaceErrorType.LEGS_INFO_NEEDED);
        }
    }

    private boolean containsCategory() {
        return this.categories != null && !this.categories.isEmpty();
    }

    private boolean containsSubCategory() {
        return this.subCategories != null && !this.subCategories.isEmpty();
    }

    public Request asHttpRequest(Environment environment, JsonMapper mapper) {
        return Request.post((URL)environment.withService(PATH), (RequestBody)RequestBody.Json.of((Object)this, (JsonMapper)mapper));
    }

    public Function<Response, PlaceRouteResponse> getResponseParser(JsonMapper mapper) {
        return response -> (PlaceRouteResponse)response.parseBodyObject(mapper, PlaceRouteResponse.class);
    }

    @Generated
    public static PlaceRouteRequestBuilder builder() {
        return new PlaceRouteRequestBuilder();
    }

    @Generated
    public Set<Category> getCategories() {
        return this.categories;
    }

    @Generated
    public Set<SubCategory> getSubCategories() {
        return this.subCategories;
    }

    @Generated
    public Long getBufferRouteInMeters() {
        return this.bufferRouteInMeters;
    }

    @Generated
    public Long getBufferStoppingPointsInMeters() {
        return this.bufferStoppingPointsInMeters;
    }

    @Generated
    public boolean isOnlyMyPlaces() {
        return this.onlyMyPlaces;
    }

    @Generated
    public List<Leg> getLegs() {
        return this.legs;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PlaceRouteRequest)) {
            return false;
        }
        PlaceRouteRequest other = (PlaceRouteRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isOnlyMyPlaces() != other.isOnlyMyPlaces()) {
            return false;
        }
        Long this$bufferRouteInMeters = this.getBufferRouteInMeters();
        Long other$bufferRouteInMeters = other.getBufferRouteInMeters();
        if (this$bufferRouteInMeters == null ? other$bufferRouteInMeters != null : !((Object)this$bufferRouteInMeters).equals(other$bufferRouteInMeters)) {
            return false;
        }
        Long this$bufferStoppingPointsInMeters = this.getBufferStoppingPointsInMeters();
        Long other$bufferStoppingPointsInMeters = other.getBufferStoppingPointsInMeters();
        if (this$bufferStoppingPointsInMeters == null ? other$bufferStoppingPointsInMeters != null : !((Object)this$bufferStoppingPointsInMeters).equals(other$bufferStoppingPointsInMeters)) {
            return false;
        }
        Set<Category> this$categories = this.getCategories();
        Set<Category> other$categories = other.getCategories();
        if (this$categories == null ? other$categories != null : !((Object)this$categories).equals(other$categories)) {
            return false;
        }
        Set<SubCategory> this$subCategories = this.getSubCategories();
        Set<SubCategory> other$subCategories = other.getSubCategories();
        if (this$subCategories == null ? other$subCategories != null : !((Object)this$subCategories).equals(other$subCategories)) {
            return false;
        }
        List<Leg> this$legs = this.getLegs();
        List<Leg> other$legs = other.getLegs();
        return !(this$legs == null ? other$legs != null : !((Object)this$legs).equals(other$legs));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PlaceRouteRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isOnlyMyPlaces() ? 79 : 97);
        Long $bufferRouteInMeters = this.getBufferRouteInMeters();
        result = result * 59 + ($bufferRouteInMeters == null ? 43 : ((Object)$bufferRouteInMeters).hashCode());
        Long $bufferStoppingPointsInMeters = this.getBufferStoppingPointsInMeters();
        result = result * 59 + ($bufferStoppingPointsInMeters == null ? 43 : ((Object)$bufferStoppingPointsInMeters).hashCode());
        Set<Category> $categories = this.getCategories();
        result = result * 59 + ($categories == null ? 43 : ((Object)$categories).hashCode());
        Set<SubCategory> $subCategories = this.getSubCategories();
        result = result * 59 + ($subCategories == null ? 43 : ((Object)$subCategories).hashCode());
        List<Leg> $legs = this.getLegs();
        result = result * 59 + ($legs == null ? 43 : ((Object)$legs).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PlaceRouteRequest(categories=" + this.getCategories() + ", subCategories=" + this.getSubCategories() + ", bufferRouteInMeters=" + this.getBufferRouteInMeters() + ", bufferStoppingPointsInMeters=" + this.getBufferStoppingPointsInMeters() + ", onlyMyPlaces=" + this.isOnlyMyPlaces() + ", legs=" + this.getLegs() + ")";
    }

    @Generated
    private PlaceRouteRequest(Set<Category> categories, Set<SubCategory> subCategories, Long bufferRouteInMeters, Long bufferStoppingPointsInMeters, boolean onlyMyPlaces, List<Leg> legs) {
        this.categories = categories;
        this.subCategories = subCategories;
        this.bufferRouteInMeters = bufferRouteInMeters;
        this.bufferStoppingPointsInMeters = bufferStoppingPointsInMeters;
        this.onlyMyPlaces = onlyMyPlaces;
        this.legs = legs;
    }

    @Generated
    public static PlaceRouteRequest of(Set<Category> categories, Set<SubCategory> subCategories, Long bufferRouteInMeters, Long bufferStoppingPointsInMeters, boolean onlyMyPlaces, List<Leg> legs) {
        return new PlaceRouteRequest(categories, subCategories, bufferRouteInMeters, bufferStoppingPointsInMeters, onlyMyPlaces, legs);
    }

    @Generated
    private PlaceRouteRequest() {
        this.categories = null;
        this.subCategories = null;
        this.bufferRouteInMeters = null;
        this.bufferStoppingPointsInMeters = null;
        this.onlyMyPlaces = false;
        this.legs = null;
    }

    @Generated
    public static class PlaceRouteRequestBuilder {
        @Generated
        private ArrayList<Category> categories;
        @Generated
        private ArrayList<SubCategory> subCategories;
        @Generated
        private Long bufferRouteInMeters;
        @Generated
        private Long bufferStoppingPointsInMeters;
        @Generated
        private boolean onlyMyPlaces;
        @Generated
        private ArrayList<Leg> legs;

        @Generated
        PlaceRouteRequestBuilder() {
        }

        @Generated
        public PlaceRouteRequestBuilder category(Category category) {
            if (this.categories == null) {
                this.categories = new ArrayList();
            }
            this.categories.add(category);
            return this;
        }

        @Generated
        public PlaceRouteRequestBuilder categories(Collection<? extends Category> categories) {
            if (categories == null) {
                throw new NullPointerException("categories cannot be null");
            }
            if (this.categories == null) {
                this.categories = new ArrayList();
            }
            this.categories.addAll(categories);
            return this;
        }

        @Generated
        public PlaceRouteRequestBuilder clearCategories() {
            if (this.categories != null) {
                this.categories.clear();
            }
            return this;
        }

        @Generated
        public PlaceRouteRequestBuilder subCategory(SubCategory subCategory) {
            if (this.subCategories == null) {
                this.subCategories = new ArrayList();
            }
            this.subCategories.add(subCategory);
            return this;
        }

        @Generated
        public PlaceRouteRequestBuilder subCategories(Collection<? extends SubCategory> subCategories) {
            if (subCategories == null) {
                throw new NullPointerException("subCategories cannot be null");
            }
            if (this.subCategories == null) {
                this.subCategories = new ArrayList();
            }
            this.subCategories.addAll(subCategories);
            return this;
        }

        @Generated
        public PlaceRouteRequestBuilder clearSubCategories() {
            if (this.subCategories != null) {
                this.subCategories.clear();
            }
            return this;
        }

        @Generated
        public PlaceRouteRequestBuilder bufferRouteInMeters(Long bufferRouteInMeters) {
            this.bufferRouteInMeters = bufferRouteInMeters;
            return this;
        }

        @Generated
        public PlaceRouteRequestBuilder bufferStoppingPointsInMeters(Long bufferStoppingPointsInMeters) {
            this.bufferStoppingPointsInMeters = bufferStoppingPointsInMeters;
            return this;
        }

        @Generated
        public PlaceRouteRequestBuilder onlyMyPlaces(boolean onlyMyPlaces) {
            this.onlyMyPlaces = onlyMyPlaces;
            return this;
        }

        @Generated
        public PlaceRouteRequestBuilder leg(Leg leg) {
            if (this.legs == null) {
                this.legs = new ArrayList();
            }
            this.legs.add(leg);
            return this;
        }

        @Generated
        public PlaceRouteRequestBuilder legs(Collection<? extends Leg> legs) {
            if (legs == null) {
                throw new NullPointerException("legs cannot be null");
            }
            if (this.legs == null) {
                this.legs = new ArrayList();
            }
            this.legs.addAll(legs);
            return this;
        }

        @Generated
        public PlaceRouteRequestBuilder clearLegs() {
            if (this.legs != null) {
                this.legs.clear();
            }
            return this;
        }

        @Generated
        public PlaceRouteRequest build() {
            List<Object> legs;
            Set<Object> subCategories;
            Set<Object> categories;
            switch (this.categories == null ? 0 : this.categories.size()) {
                case 0: {
                    categories = Collections.emptySet();
                    break;
                }
                case 1: {
                    categories = Collections.singleton(this.categories.get(0));
                    break;
                }
                default: {
                    categories = new LinkedHashSet(this.categories.size() < 0x40000000 ? 1 + this.categories.size() + (this.categories.size() - 3) / 3 : Integer.MAX_VALUE);
                    categories.addAll(this.categories);
                    categories = Collections.unmodifiableSet(categories);
                }
            }
            switch (this.subCategories == null ? 0 : this.subCategories.size()) {
                case 0: {
                    subCategories = Collections.emptySet();
                    break;
                }
                case 1: {
                    subCategories = Collections.singleton(this.subCategories.get(0));
                    break;
                }
                default: {
                    subCategories = new LinkedHashSet(this.subCategories.size() < 0x40000000 ? 1 + this.subCategories.size() + (this.subCategories.size() - 3) / 3 : Integer.MAX_VALUE);
                    subCategories.addAll(this.subCategories);
                    subCategories = Collections.unmodifiableSet(subCategories);
                }
            }
            switch (this.legs == null ? 0 : this.legs.size()) {
                case 0: {
                    legs = Collections.emptyList();
                    break;
                }
                case 1: {
                    legs = Collections.singletonList(this.legs.get(0));
                    break;
                }
                default: {
                    legs = Collections.unmodifiableList(new ArrayList<Leg>(this.legs));
                }
            }
            return new PlaceRouteRequest(categories, subCategories, this.bufferRouteInMeters, this.bufferStoppingPointsInMeters, this.onlyMyPlaces, legs);
        }

        @Generated
        public String toString() {
            return "PlaceRouteRequest.PlaceRouteRequestBuilder(categories=" + this.categories + ", subCategories=" + this.subCategories + ", bufferRouteInMeters=" + this.bufferRouteInMeters + ", bufferStoppingPointsInMeters=" + this.bufferStoppingPointsInMeters + ", onlyMyPlaces=" + this.onlyMyPlaces + ", legs=" + this.legs + ")";
        }
    }
}

