/*
 * Decompiled with CFR 0.152.
 */
package global.maplink.toll.schema.request;

import global.maplink.toll.schema.Coordinates;
import global.maplink.toll.schema.TollVehicleType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;

public class LegRequest {
    private TollVehicleType vehicleType;
    private List<Coordinates> points;

    public List<Coordinates> getPoints() {
        if (this.points == null) {
            this.points = new ArrayList<Coordinates>();
        }
        return this.points;
    }

    public static LegRequest of(TollVehicleType vehicleType, double ... coordinates) {
        if (coordinates.length % 2 != 0) {
            throw new IllegalArgumentException("Coordinates must be provided in pairs lat,lon");
        }
        if (coordinates.length == 0) {
            return new LegRequest(vehicleType, Collections.emptyList());
        }
        ArrayList<Coordinates> list = new ArrayList<Coordinates>(coordinates.length / 2);
        for (int i = 0; i < coordinates.length; i += 2) {
            list.add(Coordinates.of(coordinates[i], coordinates[i + 1]));
        }
        return new LegRequest(vehicleType, list);
    }

    @Generated
    public static LegRequestBuilder builder() {
        return new LegRequestBuilder();
    }

    @Generated
    public TollVehicleType getVehicleType() {
        return this.vehicleType;
    }

    @Generated
    public void setVehicleType(TollVehicleType vehicleType) {
        this.vehicleType = vehicleType;
    }

    @Generated
    public void setPoints(List<Coordinates> points) {
        this.points = points;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LegRequest)) {
            return false;
        }
        LegRequest other = (LegRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TollVehicleType this$vehicleType = this.getVehicleType();
        TollVehicleType other$vehicleType = other.getVehicleType();
        if (this$vehicleType == null ? other$vehicleType != null : !((Object)((Object)this$vehicleType)).equals((Object)other$vehicleType)) {
            return false;
        }
        List<Coordinates> this$points = this.getPoints();
        List<Coordinates> other$points = other.getPoints();
        return !(this$points == null ? other$points != null : !((Object)this$points).equals(other$points));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LegRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TollVehicleType $vehicleType = this.getVehicleType();
        result = result * 59 + ($vehicleType == null ? 43 : ((Object)((Object)$vehicleType)).hashCode());
        List<Coordinates> $points = this.getPoints();
        result = result * 59 + ($points == null ? 43 : ((Object)$points).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LegRequest(vehicleType=" + (Object)((Object)this.getVehicleType()) + ", points=" + this.getPoints() + ")";
    }

    @Generated
    public LegRequest() {
    }

    @Generated
    public LegRequest(TollVehicleType vehicleType, List<Coordinates> points) {
        this.vehicleType = vehicleType;
        this.points = points;
    }

    @Generated
    public static class LegRequestBuilder {
        @Generated
        private TollVehicleType vehicleType;
        @Generated
        private ArrayList<Coordinates> points;

        @Generated
        LegRequestBuilder() {
        }

        @Generated
        public LegRequestBuilder vehicleType(TollVehicleType vehicleType) {
            this.vehicleType = vehicleType;
            return this;
        }

        @Generated
        public LegRequestBuilder point(Coordinates point) {
            if (this.points == null) {
                this.points = new ArrayList();
            }
            this.points.add(point);
            return this;
        }

        @Generated
        public LegRequestBuilder points(Collection<? extends Coordinates> points) {
            if (points == null) {
                throw new NullPointerException("points cannot be null");
            }
            if (this.points == null) {
                this.points = new ArrayList();
            }
            this.points.addAll(points);
            return this;
        }

        @Generated
        public LegRequestBuilder clearPoints() {
            if (this.points != null) {
                this.points.clear();
            }
            return this;
        }

        @Generated
        public LegRequest build() {
            List<Coordinates> points;
            switch (this.points == null ? 0 : this.points.size()) {
                case 0: {
                    points = Collections.emptyList();
                    break;
                }
                case 1: {
                    points = Collections.singletonList(this.points.get(0));
                    break;
                }
                default: {
                    points = Collections.unmodifiableList(new ArrayList<Coordinates>(this.points));
                }
            }
            return new LegRequest(this.vehicleType, points);
        }

        @Generated
        public String toString() {
            return "LegRequest.LegRequestBuilder(vehicleType=" + (Object)((Object)this.vehicleType) + ", points=" + this.points + ")";
        }
    }
}

