/*
 * Decompiled with CFR 0.152.
 */
package global.namespace.archive.io.delta;

import global.namespace.archive.io.api.ArchiveEntrySource;
import global.namespace.archive.io.api.ArchiveFileInput;
import global.namespace.archive.io.api.ArchiveFileOutput;
import global.namespace.archive.io.api.ArchiveFileSink;
import global.namespace.archive.io.api.ArchiveFileSource;
import global.namespace.archive.io.delta.Delta;
import global.namespace.archive.io.delta.MessageDigests;
import global.namespace.archive.io.delta.model.DeltaModel;
import global.namespace.archive.io.delta.model.EntryNameAndDigestValue;
import global.namespace.archive.io.delta.model.EntryNameAndTwoDigestValues;
import global.namespace.fun.io.api.Source;
import global.namespace.fun.io.api.function.XFunction;
import java.security.MessageDigest;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;

abstract class ArchiveFileDiff<F, S, D> {
    ArchiveFileDiff() {
    }

    abstract MessageDigest digest();

    abstract ArchiveFileSource<F> firstSource();

    abstract ArchiveFileSource<S> secondSource();

    void to(ArchiveFileSink<D> delta) throws Exception {
        this.apply(engine -> {
            delta.acceptWriter(engine::to);
            return null;
        });
    }

    DeltaModel deltaModel() throws Exception {
        return (DeltaModel)this.apply(Engine::deltaModel);
    }

    private <T> T apply(XFunction<Engine, T> function) throws Exception {
        return (T)this.firstSource().applyReader(firstInput -> this.secondSource().applyReader(secondInput -> function.apply((Object)new Engine((ArchiveFileInput)firstInput, (ArchiveFileInput)secondInput){
            final /* synthetic */ ArchiveFileInput val$firstInput;
            final /* synthetic */ ArchiveFileInput val$secondInput;
            {
                this.val$firstInput = archiveFileInput;
                this.val$secondInput = archiveFileInput2;
            }

            @Override
            ArchiveFileInput<F> firstInput() {
                return this.val$firstInput;
            }

            @Override
            ArchiveFileInput<S> secondInput() {
                return this.val$secondInput;
            }
        })));
    }

    private abstract class Engine {
        private Engine() {
        }

        abstract ArchiveFileInput<F> firstInput();

        abstract ArchiveFileInput<S> secondInput();

        void to(final ArchiveFileOutput<D> deltaOutput) throws Exception {
            final class Streamer {
                private final DeltaModel model;

                Streamer() throws Exception {
                    this.model = Engine.this.deltaModel();
                    Delta.encodeModel(deltaOutput, this.model);
                }

                private void stream() throws Exception {
                    for (ArchiveEntrySource secondEntry : Engine.this.secondInput()) {
                        String name = secondEntry.name();
                        if (!this.changedOrAdded(name)) continue;
                        secondEntry.copyTo(deltaOutput.sink(name));
                    }
                }

                private boolean changedOrAdded(String name) {
                    return null != this.model.changed(name) || null != this.model.added(name);
                }
            }
            new Streamer().stream();
        }

        DeltaModel deltaModel() throws Exception {
            return new Assembler().walkAndReturn(new Assembly()).deltaModel();
        }

        class Assembly {
            final Map<String, EntryNameAndTwoDigestValues> changed = new TreeMap<String, EntryNameAndTwoDigestValues>();
            final Map<String, EntryNameAndDigestValue> unchanged = new TreeMap<String, EntryNameAndDigestValue>();
            final Map<String, EntryNameAndDigestValue> added = new TreeMap<String, EntryNameAndDigestValue>();
            final Map<String, EntryNameAndDigestValue> removed = new TreeMap<String, EntryNameAndDigestValue>();

            Assembly() {
            }

            DeltaModel deltaModel() {
                return DeltaModel.builder().messageDigest(ArchiveFileDiff.this.digest()).changedEntries(this.changed.values()).unchangedEntries(this.unchanged.values()).addedEntries(this.added.values()).removedEntries(this.removed.values()).build();
            }

            void visitEntriesInBothFiles(ArchiveEntrySource<F> firstSource, ArchiveEntrySource<S> secondSource) throws Exception {
                String secondValue;
                String firstName = firstSource.name();
                assert (firstName.equals(secondSource.name()));
                String firstValue = this.digestValueOf((Source)firstSource);
                if (firstValue.equals(secondValue = this.digestValueOf((Source)secondSource))) {
                    this.unchanged.put(firstName, new EntryNameAndDigestValue(firstName, firstValue));
                } else {
                    this.changed.put(firstName, new EntryNameAndTwoDigestValues(firstName, firstValue, secondValue));
                }
            }

            void visitEntryInFirstFile(ArchiveEntrySource<F> firstSource) throws Exception {
                String firstName = firstSource.name();
                this.removed.put(firstName, new EntryNameAndDigestValue(firstName, this.digestValueOf((Source)firstSource)));
            }

            void visitEntryInSecondFile(ArchiveEntrySource<S> secondSource) throws Exception {
                String secondName = secondSource.name();
                this.added.put(secondName, new EntryNameAndDigestValue(secondName, this.digestValueOf((Source)secondSource)));
            }

            String digestValueOf(Source source) throws Exception {
                MessageDigest digest = ArchiveFileDiff.this.digest();
                digest.reset();
                MessageDigests.updateDigestFrom(digest, source);
                return MessageDigests.valueOf(digest);
            }
        }

        class Assembler {
            Assembler() {
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            Assembly walkAndReturn(Assembly assembly) throws Exception {
                for (ArchiveEntrySource firstEntry : Engine.this.firstInput()) {
                    if (firstEntry.isDirectory()) continue;
                    Optional secondEntry = Engine.this.secondInput().source(firstEntry.name());
                    if (secondEntry.isPresent()) {
                        assembly.visitEntriesInBothFiles(firstEntry, (ArchiveEntrySource)secondEntry.get());
                        continue;
                    }
                    assembly.visitEntryInFirstFile(firstEntry);
                }
                for (ArchiveEntrySource secondEntry : Engine.this.secondInput()) {
                    Optional firstEntry;
                    if (secondEntry.isDirectory() || (firstEntry = Engine.this.firstInput().source(secondEntry.name())).isPresent()) continue;
                    assembly.visitEntryInSecondFile(secondEntry);
                }
                return assembly;
            }
        }
    }
}

