/*
 * Decompiled with CFR 0.152.
 */
package global.namespace.archive.io.delta;

import global.namespace.archive.io.api.ArchiveFileSink;
import global.namespace.archive.io.api.ArchiveFileSource;
import global.namespace.archive.io.delta.ArchiveFileDiff;
import global.namespace.archive.io.delta.MessageDigests;
import global.namespace.archive.io.delta.model.DeltaModel;
import java.security.MessageDigest;
import java.util.Optional;

public class ArchiveFileDiffBuilder {
    private Optional<MessageDigest> digest = Optional.empty();
    private Optional<ArchiveFileSource<?>> first = Optional.empty();
    private Optional<ArchiveFileSource<?>> second = Optional.empty();

    ArchiveFileDiffBuilder() {
    }

    public ArchiveFileDiffBuilder digest(MessageDigest digest) {
        this.digest = Optional.of(digest);
        return this;
    }

    public ArchiveFileDiffBuilder first(ArchiveFileSource<?> first) {
        this.first = Optional.of(first);
        return this;
    }

    public ArchiveFileDiffBuilder second(ArchiveFileSource<?> second) {
        this.second = Optional.of(second);
        return this;
    }

    public void to(ArchiveFileSink<?> delta) throws Exception {
        this.build().to(delta);
    }

    public DeltaModel deltaModel() throws Exception {
        return this.build().deltaModel();
    }

    private ArchiveFileDiff build() {
        return ArchiveFileDiffBuilder.create(this.digest.orElseGet(MessageDigests::sha1), this.first.get(), this.second.get());
    }

    private static ArchiveFileDiff create(final MessageDigest digest, final ArchiveFileSource<?> firstSource, final ArchiveFileSource<?> secondSource) {
        return new ArchiveFileDiff(){

            @Override
            MessageDigest digest() {
                return digest;
            }

            ArchiveFileSource<?> firstSource() {
                return firstSource;
            }

            ArchiveFileSource<?> secondSource() {
                return secondSource;
            }
        };
    }
}

