/*
 * Decompiled with CFR 0.152.
 */
package global.namespace.archive.io.delta;

import global.namespace.archive.io.api.ArchiveFileInput;
import global.namespace.archive.io.api.ArchiveFileOutput;
import global.namespace.archive.io.api.ArchiveFileSink;
import global.namespace.archive.io.api.ArchiveFileSource;
import global.namespace.archive.io.delta.Delta;
import global.namespace.archive.io.delta.InvalidDeltaArchiveFileException;
import global.namespace.archive.io.delta.MessageDigests;
import global.namespace.archive.io.delta.MissingArchiveEntryException;
import global.namespace.archive.io.delta.WrongFirstArchiveFileException;
import global.namespace.archive.io.delta.WrongMessageDigestException;
import global.namespace.archive.io.delta.model.DeltaModel;
import global.namespace.archive.io.delta.model.EntryNameAndDigestValue;
import global.namespace.archive.io.delta.model.EntryNameAndTwoDigestValues;
import global.namespace.fun.io.api.Sink;
import global.namespace.fun.io.api.Socket;
import global.namespace.fun.io.api.Source;
import global.namespace.fun.io.api.function.XConsumer;
import global.namespace.fun.io.bios.BIOS;
import java.io.IOException;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;

abstract class ArchiveFilePatch<F, D, S> {
    ArchiveFilePatch() {
    }

    abstract ArchiveFileSource<F> firstSource();

    abstract ArchiveFileSource<D> deltaSource();

    void to(ArchiveFileSink<S> second) throws Exception {
        this.accept((XConsumer<Engine>)((XConsumer)engine -> second.acceptWriter(engine::to)));
    }

    private void accept(XConsumer<Engine> consumer) throws Exception {
        this.firstSource().acceptReader(firstInput -> this.deltaSource().acceptReader(deltaInput -> consumer.accept((Object)new Engine((ArchiveFileInput)firstInput, (ArchiveFileInput)deltaInput){
            final /* synthetic */ ArchiveFileInput val$firstInput;
            final /* synthetic */ ArchiveFileInput val$deltaInput;
            {
                this.val$firstInput = archiveFileInput;
                this.val$deltaInput = archiveFileInput2;
            }

            @Override
            ArchiveFileInput<F> firstInput() {
                return this.val$firstInput;
            }

            @Override
            ArchiveFileInput<D> deltaInput() {
                return this.val$deltaInput;
            }
        })));
    }

    private abstract class Engine {
        DeltaModel model;

        private Engine() {
        }

        abstract ArchiveFileInput<F> firstInput();

        abstract ArchiveFileInput<D> deltaInput();

        void to(ArchiveFileOutput<S> secondOutput) throws Exception {
            for (Predicate<String> filter : this.passFilters(secondOutput)) {
                this.to(secondOutput, t -> !t.endsWith("/") && filter.test((String)t));
            }
        }

        Iterable<Predicate<String>> passFilters(ArchiveFileOutput<S> secondOutput) {
            if (secondOutput.isJar()) {
                Predicate<String> manifestFilter = "META-INF/MANIFEST.MF"::equals;
                return Arrays.asList(manifestFilter, manifestFilter.negate());
            }
            return Collections.singletonList(t -> true);
        }

        void to(final ArchiveFileOutput<S> secondOutput, final Predicate<String> filter) throws Exception {
            class OnFirstInputPatch
            extends 1Patch<F> {
                OnFirstInputPatch() {
                    abstract class Patch<E> {
                        final /* synthetic */ Predicate val$filter;
                        final /* synthetic */ ArchiveFileOutput val$secondOutput;

                        Patch() {
                            this.val$filter = predicate;
                            this.val$secondOutput = archiveFileOutput;
                        }

                        abstract ArchiveFileInput<E> input();

                        abstract IOException ioException(Throwable var1);

                        final void apply(Collection<EntryNameAndDigestValue> collection) throws Exception {
                            for (EntryNameAndDigestValue entryNameAndDigestValue : collection) {
                                String name = entryNameAndDigestValue.entryName();
                                if (!this.val$filter.test(name)) continue;
                                Optional entry = this.input().source(name);
                                try {
                                    class MyArchiveEntrySink
                                    implements Sink {
                                        private final EntryNameAndDigestValue entryNameAndDigest;
                                        final /* synthetic */ ArchiveFileOutput val$secondOutput;

                                        MyArchiveEntrySink(EntryNameAndDigestValue entryNameAndDigest) {
                                            this.val$secondOutput = archiveFileOutput;
                                            assert (null != entryNameAndDigest);
                                            this.entryNameAndDigest = entryNameAndDigest;
                                        }

                                        public Socket<OutputStream> output() {
                                            return this.val$secondOutput.sink(this.entryNameAndDigest.entryName()).output().map(out -> {
                                                MessageDigest digest = Engine.this.digest();
                                                digest.reset();
                                                return new DigestOutputStream((OutputStream)out, digest){

                                                    @Override
                                                    public void close() throws IOException {
                                                        super.close();
                                                        if (!this.valueOfDigest().equals(entryNameAndDigest.digestValue())) {
                                                            throw new WrongMessageDigestException(entryNameAndDigest.entryName());
                                                        }
                                                    }

                                                    String valueOfDigest() {
                                                        return MessageDigests.valueOf(this.digest);
                                                    }
                                                };
                                            });
                                        }
                                    }
                                    BIOS.copy((Source)((Source)entry.orElseThrow(() -> this.ioException(new MissingArchiveEntryException(name)))), (Sink)new MyArchiveEntrySink(Engine.this, entryNameAndDigestValue, this.val$secondOutput));
                                }
                                catch (WrongMessageDigestException e) {
                                    throw this.ioException(e);
                                }
                            }
                        }
                    }
                    super(Engine.this, predicate, archiveFileOutput);
                }

                @Override
                ArchiveFileInput<F> input() {
                    return Engine.this.firstInput();
                }

                @Override
                IOException ioException(Throwable cause) {
                    return new WrongFirstArchiveFileException(cause);
                }
            }
            new OnFirstInputPatch().apply(this.model().unchangedEntries());
            class OnDeltaInputPatch
            extends 1Patch<D> {
                OnDeltaInputPatch() {
                    super(Engine.this, predicate, archiveFileOutput);
                }

                @Override
                ArchiveFileInput<D> input() {
                    return Engine.this.deltaInput();
                }

                @Override
                IOException ioException(Throwable cause) {
                    return new InvalidDeltaArchiveFileException(cause);
                }
            }
            new OnDeltaInputPatch().apply(this.model().changedEntries().stream().map(EntryNameAndTwoDigestValues::secondEntryNameAndDigestValue).collect(Collectors.toList()));
            new OnDeltaInputPatch().apply(this.model().addedEntries());
        }

        MessageDigest digest() throws Exception {
            return MessageDigest.getInstance(this.model().digestAlgorithmName());
        }

        DeltaModel model() throws Exception {
            DeltaModel model = this.model;
            return null != model ? model : (this.model = Delta.decodeModel(this.deltaInput()));
        }
    }
}

