/*
 * Decompiled with CFR 0.152.
 */
package global.namespace.archive.io.delta;

import global.namespace.archive.io.api.ArchiveFileSink;
import global.namespace.archive.io.api.ArchiveFileSource;
import global.namespace.archive.io.delta.ArchiveFilePatch;
import java.util.Optional;

public class ArchiveFilePatchBuilder {
    private Optional<ArchiveFileSource<?>> first = Optional.empty();
    private Optional<ArchiveFileSource<?>> delta = Optional.empty();

    ArchiveFilePatchBuilder() {
    }

    public ArchiveFilePatchBuilder first(ArchiveFileSource<?> first) {
        this.first = Optional.of(first);
        return this;
    }

    public ArchiveFilePatchBuilder delta(ArchiveFileSource<?> delta) {
        this.delta = Optional.of(delta);
        return this;
    }

    public void to(ArchiveFileSink<?> second) throws Exception {
        this.build().to(second);
    }

    private ArchiveFilePatch build() {
        return ArchiveFilePatchBuilder.create(this.first.get(), this.delta.get());
    }

    private static ArchiveFilePatch create(final ArchiveFileSource<?> firstSource, final ArchiveFileSource<?> deltaSource) {
        return new ArchiveFilePatch(){

            ArchiveFileSource<?> firstSource() {
                return firstSource;
            }

            ArchiveFileSource<?> deltaSource() {
                return deltaSource;
            }
        };
    }
}

