/*
 * Decompiled with CFR 0.152.
 */
package global.namespace.archive.io.delta;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import global.namespace.archive.io.api.ArchiveFileInput;
import global.namespace.archive.io.api.ArchiveFileOutput;
import global.namespace.archive.io.delta.ArchiveFileDiffBuilder;
import global.namespace.archive.io.delta.ArchiveFilePatchBuilder;
import global.namespace.archive.io.delta.InvalidDeltaArchiveFileException;
import global.namespace.archive.io.delta.MissingArchiveEntryException;
import global.namespace.archive.io.delta.dto.DeltaDTO;
import global.namespace.archive.io.delta.dto.EntryNameAndDigestValueDTO;
import global.namespace.archive.io.delta.dto.EntryNameAndTwoDigestValuesDTO;
import global.namespace.archive.io.delta.model.DeltaModel;
import global.namespace.archive.io.delta.model.EntryNameAndDigestValue;
import global.namespace.archive.io.delta.model.EntryNameAndTwoDigestValues;
import global.namespace.fun.io.api.Codec;
import global.namespace.fun.io.api.Sink;
import global.namespace.fun.io.api.Source;
import global.namespace.fun.io.jackson.Jackson;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class Delta {
    private static final String META_INF_DELTA_JSON = "META-INF/delta.json";

    private Delta() {
    }

    public static ArchiveFileDiffBuilder diff() {
        return new ArchiveFileDiffBuilder();
    }

    public static ArchiveFilePatchBuilder patch() {
        return new ArchiveFilePatchBuilder();
    }

    static <E> void encodeModel(ArchiveFileOutput<E> output, DeltaModel model) throws Exception {
        Delta.encodeModel((Sink)output.sink(META_INF_DELTA_JSON), model);
    }

    static <E> DeltaModel decodeModel(ArchiveFileInput<E> input) throws Exception {
        return Delta.decodeModel((Source)input.source(META_INF_DELTA_JSON).orElseThrow(() -> new InvalidDeltaArchiveFileException(new MissingArchiveEntryException(META_INF_DELTA_JSON))));
    }

    static void encodeModel(Sink sink, DeltaModel model) throws Exception {
        Delta.encodeDTO(sink, Delta.marshal(model));
    }

    static DeltaModel decodeModel(Source source) throws Exception {
        return Delta.unmarshal(Delta.decodeDTO(source));
    }

    private static void encodeDTO(Sink sink, DeltaDTO dto) throws Exception {
        Delta.jsonCodec().encoder(sink).encode((Object)dto);
    }

    private static DeltaDTO decodeDTO(Source source) throws Exception {
        return (DeltaDTO)Delta.jsonCodec().decoder(source).decode(DeltaDTO.class);
    }

    private static Codec jsonCodec() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_DEFAULT);
        return Jackson.jsonCodec((ObjectMapper)mapper);
    }

    private static DeltaDTO marshal(DeltaModel v) {
        if (null == v) {
            return null;
        }
        DeltaDTO dto = new DeltaDTO();
        dto.algorithm = v.digestAlgorithmName();
        dto.numBytes = v.digestByteLength().orElse(0);
        dto.changed = Delta.marshal2(v.changedEntries());
        dto.unchanged = Delta.marshal(v.unchangedEntries());
        dto.added = Delta.marshal(v.addedEntries());
        dto.removed = Delta.marshal(v.removedEntries());
        return dto;
    }

    private static DeltaModel unmarshal(DeltaDTO v) throws Exception {
        if (null == v) {
            return null;
        }
        return DeltaModel.builder().messageDigest(MessageDigest.getInstance(v.algorithm)).changedEntries(Delta.unmarshal2(v.changed)).unchangedEntries(Delta.unmarshal(v.unchanged)).addedEntries(Delta.unmarshal(v.added)).removedEntries(Delta.unmarshal(v.removed)).build();
    }

    private static EntryNameAndTwoDigestValuesDTO[] marshal2(Collection<EntryNameAndTwoDigestValues> v) {
        if (null == v || v.isEmpty()) {
            return null;
        }
        return (EntryNameAndTwoDigestValuesDTO[])v.stream().map(entry -> {
            EntryNameAndTwoDigestValuesDTO dto = new EntryNameAndTwoDigestValuesDTO();
            dto.name = entry.entryName();
            dto.first = entry.firstDigestValue();
            dto.second = entry.secondDigestValue();
            return dto;
        }).toArray(EntryNameAndTwoDigestValuesDTO[]::new);
    }

    private static List<EntryNameAndTwoDigestValues> unmarshal2(EntryNameAndTwoDigestValuesDTO[] v) {
        return null == v ? Collections.emptyList() : Arrays.stream(v).map(dto -> new EntryNameAndTwoDigestValues(dto.name, dto.first, dto.second)).collect(Collectors.toList());
    }

    private static EntryNameAndDigestValueDTO[] marshal(Collection<EntryNameAndDigestValue> v) {
        if (null == v || v.isEmpty()) {
            return null;
        }
        return (EntryNameAndDigestValueDTO[])v.stream().map(entry -> {
            EntryNameAndDigestValueDTO dto = new EntryNameAndDigestValueDTO();
            dto.name = entry.entryName();
            dto.digest = entry.digestValue();
            return dto;
        }).toArray(EntryNameAndDigestValueDTO[]::new);
    }

    private static List<EntryNameAndDigestValue> unmarshal(EntryNameAndDigestValueDTO[] v) {
        return null == v ? Collections.emptyList() : Arrays.stream(v).map(dto -> new EntryNameAndDigestValue(dto.name, dto.digest)).collect(Collectors.toList());
    }
}

