/*
 * Decompiled with CFR 0.152.
 */
package global.namespace.archive.io.delta;

import global.namespace.fun.io.api.Source;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

class MessageDigests {
    private MessageDigests() {
    }

    static MessageDigest sha1() {
        try {
            return MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    static String valueOf(MessageDigest digest) {
        return new BigInteger(1, digest.digest()).toString(16);
    }

    static void updateDigestFrom(MessageDigest digest, Source source) throws Exception {
        source.acceptReader(in -> {
            int read;
            byte[] buffer = new byte[8192];
            while (0 <= (read = in.read(buffer))) {
                digest.update(buffer, 0, read);
            }
        });
    }
}

