/*
 * Decompiled with CFR 0.152.
 */
package global.namespace.fun.io.aws.sdk2;

import global.namespace.fun.io.api.ArchiveEntrySink;
import global.namespace.fun.io.api.ArchiveEntrySource;
import global.namespace.fun.io.api.ArchiveInputStream;
import global.namespace.fun.io.api.ArchiveOutputStream;
import global.namespace.fun.io.api.ArchiveStore;
import global.namespace.fun.io.api.Sink;
import global.namespace.fun.io.api.Socket;
import global.namespace.fun.io.api.Source;
import global.namespace.fun.io.spi.ArchiveEntryNames;
import global.namespace.fun.io.spi.Copy;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.S3Object;

public final class AWS {
    private AWS() {
    }

    public static ArchiveStore s3(S3Client client, String bucket) {
        return AWS.s3(client, bucket, "");
    }

    public static ArchiveStore s3(S3Client client, String bucket, String prefix) {
        String normalized;
        String string = normalized = prefix.isEmpty() ? prefix : ArchiveEntryNames.requireInternal((String)prefix);
        if (!normalized.equals(prefix)) {
            throw new IllegalArgumentException("prefix must be in normalized form, but is `" + prefix + "`.");
        }
        if (!normalized.isEmpty() && !normalized.endsWith("/")) {
            throw new IllegalArgumentException("prefix must be empty or end with a `/`, but is `" + prefix + "`.");
        }
        return AWS.checked(client, bucket, normalized);
    }

    private static ArchiveStore checked(final S3Client client, final String bucket, final String prefix) {
        return new ArchiveStore(){

            public Socket<ArchiveInputStream> input() {
                return () -> new ArchiveInputStream(){
                    Map objects = new LinkedHashMap();
                    {
                        client.listObjectsV2Paginator(b -> b.bucket(bucket).prefix(prefix)).forEach(response -> response.contents().forEach(object -> this.objects.put(object.key().substring(prefix.length()), object)));
                    }

                    public Iterator<ArchiveEntrySource> iterator() {
                        return Objects.requireNonNull(this.objects, "Already closed.").values().stream().map(this::source).iterator();
                    }

                    public Optional<ArchiveEntrySource> source(String name) {
                        return Optional.ofNullable(Objects.requireNonNull(this.objects, "Already closed.").get(ArchiveEntryNames.requireInternal((String)name))).map(this::source);
                    }

                    ArchiveEntrySource source(final S3Object object) {
                        return new ArchiveEntrySource(){

                            public Socket<InputStream> input() {
                                return () -> client.getObject(b -> b.bucket(bucket).key(object.key()));
                            }

                            public String name() {
                                return object.key().substring(prefix.length());
                            }

                            public boolean directory() {
                                return object.key().endsWith("/");
                            }

                            public long size() {
                                return object.size();
                            }
                        };
                    }

                    public void close() {
                        this.objects = null;
                    }
                };
            }

            public Socket<ArchiveOutputStream> output() {
                return () -> new ArchiveOutputStream(){

                    public ArchiveEntrySink sink(String name) {
                        return this.sink((S3Object)S3Object.builder().key(prefix + ArchiveEntryNames.requireInternal((String)name)).build());
                    }

                    ArchiveEntrySink sink(final S3Object object) {
                        return new ArchiveEntrySink(){

                            public void copyFrom(ArchiveEntrySource source) throws Exception {
                                Copy.copy((Source)source, (Sink)this);
                            }

                            public Socket<OutputStream> output() {
                                return () -> {
                                    final File temp = File.createTempFile("tmp", null);
                                    temp.deleteOnExit();
                                    return new FileOutputStream(temp){

                                        @Override
                                        public void close() throws IOException {
                                            super.close();
                                            if (temp.isFile()) {
                                                try {
                                                    client.putObject(b -> b.bucket(bucket).key(object.key()), RequestBody.fromFile((File)temp));
                                                }
                                                finally {
                                                    temp.delete();
                                                }
                                            }
                                        }
                                    };
                                };
                            }
                        };
                    }

                    public void close() {
                    }
                };
            }
        };
    }
}

