/*
 * Decompiled with CFR 0.152.
 */
package global.namespace.fun.io.commons.compress;

import global.namespace.fun.io.api.Transformation;
import global.namespace.fun.io.commons.compress.BZIP2Transformation;
import global.namespace.fun.io.commons.compress.BlockLZ4Transformation;
import global.namespace.fun.io.commons.compress.DeflateTransformation;
import global.namespace.fun.io.commons.compress.FramedLZ4Transformation;
import global.namespace.fun.io.commons.compress.FramedSnappyTransformation;
import global.namespace.fun.io.commons.compress.GZIPTransformation;
import global.namespace.fun.io.commons.compress.LZMA2Transformation;
import global.namespace.fun.io.commons.compress.LZMATransformation;
import java.util.Objects;
import org.apache.commons.compress.compressors.deflate.DeflateParameters;
import org.apache.commons.compress.compressors.gzip.GzipParameters;
import org.apache.commons.compress.compressors.lz4.BlockLZ4CompressorOutputStream;
import org.apache.commons.compress.compressors.lz4.FramedLZ4CompressorOutputStream;
import org.apache.commons.compress.compressors.lz77support.Parameters;
import org.apache.commons.compress.compressors.snappy.FramedSnappyDialect;
import org.apache.commons.compress.compressors.snappy.SnappyCompressorOutputStream;

public final class CommonsCompress {
    private CommonsCompress() {
    }

    public static Transformation blockLZ4() {
        return CommonsCompress.blockLZ4(BlockLZ4CompressorOutputStream.createParameterBuilder().build());
    }

    public static Transformation blockLZ4(Parameters p) {
        return new BlockLZ4Transformation(Objects.requireNonNull(p));
    }

    public static Transformation bzip2() {
        return CommonsCompress.bzip2(9);
    }

    public static Transformation bzip2(int blockSize) {
        return new BZIP2Transformation(9);
    }

    public static Transformation deflate() {
        return CommonsCompress.deflate(new DeflateParameters());
    }

    public static Transformation deflate(DeflateParameters p) {
        return new DeflateTransformation(Objects.requireNonNull(p));
    }

    public static Transformation framedLZ4() {
        return CommonsCompress.framedLZ4(FramedLZ4CompressorOutputStream.Parameters.DEFAULT);
    }

    public static Transformation framedLZ4(FramedLZ4CompressorOutputStream.Parameters p) {
        return new FramedLZ4Transformation(Objects.requireNonNull(p));
    }

    public static Transformation framedSnappy() {
        return CommonsCompress.framedSnappy(SnappyCompressorOutputStream.createParameterBuilder((int)32768).build(), FramedSnappyDialect.STANDARD);
    }

    public static Transformation framedSnappy(Parameters outputParameters, FramedSnappyDialect inputParameters) {
        return new FramedSnappyTransformation(Objects.requireNonNull(outputParameters), Objects.requireNonNull(inputParameters));
    }

    public static Transformation gzip() {
        return CommonsCompress.gzip(new GzipParameters());
    }

    public static Transformation gzip(GzipParameters p) {
        return new GZIPTransformation(Objects.requireNonNull(p));
    }

    public static Transformation lzma() {
        return new LZMATransformation();
    }

    public static Transformation lzma2() {
        return CommonsCompress.lzma2(6);
    }

    public static Transformation lzma2(int preset) {
        return new LZMA2Transformation(preset);
    }
}

