/*
 * Decompiled with CFR 0.152.
 */
package global.namespace.fun.io.commons.compress;

import global.namespace.fun.io.api.Filter;
import global.namespace.fun.io.api.Socket;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;

final class BZIP2Filter
implements Filter {
    private final int blockSize;

    BZIP2Filter(int blockSize) {
        if (blockSize < 1 || 9 < blockSize) {
            throw new IllegalArgumentException("Block size " + blockSize + " is out of range from " + 1 + " to " + 9 + ".");
        }
        this.blockSize = blockSize;
    }

    public Socket<OutputStream> apply(Socket<OutputStream> output) {
        return output.map(out -> new BZip2CompressorOutputStream(out, this.blockSize));
    }

    public Socket<InputStream> unapply(Socket<InputStream> input) {
        return input.map(BZip2CompressorInputStream::new);
    }
}

