/*
 * Decompiled with CFR 0.152.
 */
package global.namespace.fun.io.commons.compress;

import global.namespace.fun.io.api.ArchiveInput;
import global.namespace.fun.io.api.ArchiveOutput;
import global.namespace.fun.io.api.ArchiveStore;
import global.namespace.fun.io.api.Filter;
import global.namespace.fun.io.api.Socket;
import global.namespace.fun.io.api.Store;
import global.namespace.fun.io.commons.compress.BZIP2Filter;
import global.namespace.fun.io.commons.compress.BlockLZ4Filter;
import global.namespace.fun.io.commons.compress.DeflateFilter;
import global.namespace.fun.io.commons.compress.FramedLZ4Filter;
import global.namespace.fun.io.commons.compress.FramedSnappyFilter;
import global.namespace.fun.io.commons.compress.GZIPFilter;
import global.namespace.fun.io.commons.compress.JarArchiveOutputStreamAdapter;
import global.namespace.fun.io.commons.compress.LZMA2Filter;
import global.namespace.fun.io.commons.compress.LZMAFilter;
import global.namespace.fun.io.commons.compress.SevenZFileAdapter;
import global.namespace.fun.io.commons.compress.SevenZOutputFileAdapter;
import global.namespace.fun.io.commons.compress.TarArchiveInputStreamAdapter;
import global.namespace.fun.io.commons.compress.TarArchiveOutputStreamAdapter;
import global.namespace.fun.io.commons.compress.ZipArchiveOutputStreamAdapter;
import global.namespace.fun.io.commons.compress.ZipFileAdapter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.commons.compress.archivers.jar.JarArchiveOutputStream;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;
import org.apache.commons.compress.archivers.sevenz.SevenZOutputFile;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.compressors.deflate.DeflateParameters;
import org.apache.commons.compress.compressors.gzip.GzipParameters;
import org.apache.commons.compress.compressors.lz4.BlockLZ4CompressorOutputStream;
import org.apache.commons.compress.compressors.lz4.FramedLZ4CompressorOutputStream;
import org.apache.commons.compress.compressors.lz77support.Parameters;
import org.apache.commons.compress.compressors.snappy.FramedSnappyDialect;
import org.apache.commons.compress.compressors.snappy.SnappyCompressorOutputStream;

public final class CommonsCompress {
    private CommonsCompress() {
    }

    public static Filter blockLZ4() {
        return CommonsCompress.blockLZ4(BlockLZ4CompressorOutputStream.createParameterBuilder().build());
    }

    public static Filter blockLZ4(Parameters p) {
        return new BlockLZ4Filter(Objects.requireNonNull(p));
    }

    public static Filter bzip2() {
        return CommonsCompress.bzip2(9);
    }

    public static Filter bzip2(int blockSize) {
        return new BZIP2Filter(9);
    }

    public static Filter deflate() {
        return CommonsCompress.deflate(new DeflateParameters());
    }

    public static Filter deflate(DeflateParameters p) {
        return new DeflateFilter(Objects.requireNonNull(p));
    }

    public static Filter framedLZ4() {
        return CommonsCompress.framedLZ4(FramedLZ4CompressorOutputStream.Parameters.DEFAULT);
    }

    public static Filter framedLZ4(FramedLZ4CompressorOutputStream.Parameters p) {
        return new FramedLZ4Filter(Objects.requireNonNull(p));
    }

    public static Filter framedSnappy() {
        return CommonsCompress.framedSnappy(SnappyCompressorOutputStream.createParameterBuilder((int)32768).build(), FramedSnappyDialect.STANDARD);
    }

    public static Filter framedSnappy(Parameters outputParameters, FramedSnappyDialect inputParameters) {
        return new FramedSnappyFilter(Objects.requireNonNull(outputParameters), Objects.requireNonNull(inputParameters));
    }

    public static Filter gzip() {
        return CommonsCompress.gzip(new GzipParameters());
    }

    public static Filter gzip(GzipParameters p) {
        return new GZIPFilter(Objects.requireNonNull(p));
    }

    @Deprecated
    public static Filter lzma() {
        return new LZMAFilter();
    }

    @Deprecated
    public static Filter lzma2() {
        return CommonsCompress.lzma2(6);
    }

    @Deprecated
    public static Filter lzma2(int preset) {
        return new LZMA2Filter(preset);
    }

    public static ArchiveStore<ZipArchiveEntry> jar(final File path) {
        Objects.requireNonNull(path);
        return new ArchiveStore<ZipArchiveEntry>(){

            public Socket<ArchiveInput<ZipArchiveEntry>> input() {
                return () -> new ZipFileAdapter(new ZipFile(path));
            }

            public Socket<ArchiveOutput<ZipArchiveEntry>> output() {
                return () -> new JarArchiveOutputStreamAdapter(new JarArchiveOutputStream((OutputStream)new FileOutputStream(path)));
            }
        };
    }

    public static ArchiveStore<ZipArchiveEntry> jar(String path) {
        return CommonsCompress.jar(new File(path));
    }

    public static ArchiveStore<SevenZArchiveEntry> sevenz(final File path) {
        Objects.requireNonNull(path);
        return new ArchiveStore<SevenZArchiveEntry>(){

            public Socket<ArchiveInput<SevenZArchiveEntry>> input() {
                return () -> new SevenZFileAdapter(new SevenZFile(path));
            }

            public Socket<ArchiveOutput<SevenZArchiveEntry>> output() {
                return () -> new SevenZOutputFileAdapter(new SevenZOutputFile(path));
            }
        };
    }

    public static ArchiveStore<TarArchiveEntry> tar(final Store store) {
        Objects.requireNonNull(store);
        return new ArchiveStore<TarArchiveEntry>(){

            public Socket<ArchiveInput<TarArchiveEntry>> input() {
                return store.input().map(in -> new TarArchiveInputStreamAdapter(new TarArchiveInputStream(in)));
            }

            public Socket<ArchiveOutput<TarArchiveEntry>> output() {
                return store.output().map(out -> new TarArchiveOutputStreamAdapter(new TarArchiveOutputStream(out)));
            }
        };
    }

    public static ArchiveStore<ZipArchiveEntry> zip(final File path) {
        Objects.requireNonNull(path);
        return new ArchiveStore<ZipArchiveEntry>(){

            public Socket<ArchiveInput<ZipArchiveEntry>> input() {
                return () -> new ZipFileAdapter(new ZipFile(path));
            }

            public Socket<ArchiveOutput<ZipArchiveEntry>> output() {
                return () -> new ZipArchiveOutputStreamAdapter(new ZipArchiveOutputStream(path));
            }
        };
    }

    public static ArchiveStore<ZipArchiveEntry> zip(String path) {
        return CommonsCompress.zip(new File(path));
    }
}

