/*
 * Decompiled with CFR 0.152.
 */
package global.namespace.fun.io.commons.compress;

import global.namespace.fun.io.api.Filter;
import global.namespace.fun.io.api.Socket;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipParameters;

final class GZIPFilter
implements Filter {
    private final GzipParameters parameters;

    GZIPFilter(GzipParameters p) {
        this.parameters = p;
    }

    public Socket<OutputStream> apply(Socket<OutputStream> output) {
        return output.map(out -> new GzipCompressorOutputStream(out, this.parameters));
    }

    public Socket<InputStream> unapply(Socket<InputStream> input) {
        return input.map(GzipCompressorInputStream::new);
    }
}

