/*
 * Decompiled with CFR 0.152.
 */
package global.namespace.fun.io.commons.compress;

import global.namespace.fun.io.api.Filter;
import global.namespace.fun.io.api.Socket;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorOutputStream;

final class LZMA2Filter
implements Filter {
    private final int preset;

    LZMA2Filter(int preset) {
        this.preset = preset;
    }

    public Socket<OutputStream> apply(Socket<OutputStream> output) {
        return output.map(os -> new XZCompressorOutputStream(os, this.preset));
    }

    public Socket<InputStream> unapply(Socket<InputStream> input) {
        return input.map(XZCompressorInputStream::new);
    }
}

