/*
 * Decompiled with CFR 0.152.
 */
package global.namespace.fun.io.commons.compress;

import global.namespace.fun.io.api.ArchiveEntrySource;
import global.namespace.fun.io.api.ArchiveInput;
import global.namespace.fun.io.api.Socket;
import global.namespace.fun.io.spi.ArchiveEntryNames;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;

final class SevenZFileAdapter
implements ArchiveInput<SevenZArchiveEntry> {
    private final SevenZFile sevenz;

    SevenZFileAdapter(SevenZFile sevenz) {
        this.sevenz = sevenz;
    }

    public Iterator<ArchiveEntrySource<SevenZArchiveEntry>> iterator() {
        return new Iterator<ArchiveEntrySource<SevenZArchiveEntry>>(){
            Object next;

            @Override
            public boolean hasNext() {
                if (null != this.next) {
                    return true;
                }
                try {
                    SevenZArchiveEntry entry;
                    while (null != (entry = SevenZFileAdapter.this.sevenz.getNextEntry())) {
                        if (!ArchiveEntryNames.isInternal((String)entry.getName())) continue;
                        this.next = entry;
                        return true;
                    }
                }
                catch (IOException e) {
                    this.next = e;
                    return true;
                }
                return false;
            }

            @Override
            public ArchiveEntrySource<SevenZArchiveEntry> next() {
                if (this.hasNext()) {
                    if (this.next instanceof SevenZArchiveEntry) {
                        SevenZArchiveEntry entry = (SevenZArchiveEntry)this.next;
                        this.next = null;
                        return SevenZFileAdapter.this.source(entry);
                    }
                    if (this.next instanceof Exception) {
                        throw (NoSuchElementException)new NoSuchElementException(this.next.toString()).initCause((Exception)this.next);
                    }
                }
                throw new NoSuchElementException();
            }
        };
    }

    public Optional<ArchiveEntrySource<SevenZArchiveEntry>> source(String name) {
        throw new UnsupportedOperationException();
    }

    private ArchiveEntrySource<SevenZArchiveEntry> source(final SevenZArchiveEntry entry) {
        return new ArchiveEntrySource<SevenZArchiveEntry>(){

            public String name() {
                return entry.getName();
            }

            public long size() {
                return entry.getSize();
            }

            public boolean isDirectory() {
                return entry.isDirectory();
            }

            public SevenZArchiveEntry entry() {
                return entry;
            }

            public Socket<InputStream> input() {
                return () -> new InputStream(){

                    @Override
                    public int read() throws IOException {
                        return SevenZFileAdapter.this.sevenz.read();
                    }

                    @Override
                    public int read(byte[] b) throws IOException {
                        return SevenZFileAdapter.this.sevenz.read(b);
                    }

                    @Override
                    public int read(byte[] b, int off, int len) throws IOException {
                        return SevenZFileAdapter.this.sevenz.read(b, off, len);
                    }
                };
            }
        };
    }

    public void close() throws IOException {
        this.sevenz.close();
    }
}

