/*
 * Decompiled with CFR 0.152.
 */
package global.namespace.fun.io.commons.compress;

import global.namespace.fun.io.api.ArchiveEntrySink;
import global.namespace.fun.io.api.ArchiveEntrySource;
import global.namespace.fun.io.api.ArchiveOutput;
import global.namespace.fun.io.api.Sink;
import global.namespace.fun.io.api.Socket;
import global.namespace.fun.io.spi.ArchiveEntryNames;
import global.namespace.fun.io.spi.Copy;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZOutputFile;

final class SevenZOutputFileAdapter
implements ArchiveOutput<SevenZArchiveEntry> {
    private final SevenZOutputFile sevenz;

    SevenZOutputFileAdapter(SevenZOutputFile sevenz) {
        this.sevenz = sevenz;
    }

    public boolean isJar() {
        return false;
    }

    public ArchiveEntrySink<SevenZArchiveEntry> sink(String name) {
        SevenZArchiveEntry entry = new SevenZArchiveEntry();
        entry.setName(ArchiveEntryNames.requireInternal((String)name));
        return this.sink(entry);
    }

    private ArchiveEntrySink<SevenZArchiveEntry> sink(final SevenZArchiveEntry entry) {
        return new ArchiveEntrySink<SevenZArchiveEntry>(){

            public String name() {
                return entry.getName();
            }

            public long size() {
                return entry.getSize();
            }

            public boolean isDirectory() {
                return entry.isDirectory();
            }

            public SevenZArchiveEntry entry() {
                return entry;
            }

            public Socket<OutputStream> output() {
                return () -> {
                    SevenZOutputFileAdapter.this.sevenz.putArchiveEntry((ArchiveEntry)entry);
                    return new OutputStream(){
                        boolean closed;

                        @Override
                        public void write(int b) throws IOException {
                            SevenZOutputFileAdapter.this.sevenz.write(b);
                        }

                        @Override
                        public void write(byte[] b) throws IOException {
                            SevenZOutputFileAdapter.this.sevenz.write(b);
                        }

                        @Override
                        public void write(byte[] b, int off, int len) throws IOException {
                            SevenZOutputFileAdapter.this.sevenz.write(b, off, len);
                        }

                        @Override
                        public void flush() {
                        }

                        @Override
                        public void close() throws IOException {
                            if (!this.closed) {
                                this.closed = true;
                                SevenZOutputFileAdapter.this.sevenz.closeArchiveEntry();
                            }
                        }
                    };
                };
            }

            public void copyFrom(ArchiveEntrySource<?> source) throws Exception {
                entry.setSize(source.size());
                entry.setDirectory(source.isDirectory());
                Copy.copy(source, (Sink)this);
            }
        };
    }

    public void close() throws IOException {
        this.sevenz.close();
    }
}

