/*
 * Decompiled with CFR 0.152.
 */
package global.namespace.fun.io.commons.compress;

import global.namespace.fun.io.api.ArchiveEntrySource;
import global.namespace.fun.io.api.ArchiveInput;
import global.namespace.fun.io.api.Socket;
import global.namespace.fun.io.spi.ArchiveEntryNames;
import global.namespace.fun.io.spi.UncloseableInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;

final class TarArchiveInputStreamAdapter
implements ArchiveInput<TarArchiveEntry> {
    private final TarArchiveInputStream tar;

    TarArchiveInputStreamAdapter(TarArchiveInputStream tar) {
        this.tar = tar;
    }

    public Iterator<ArchiveEntrySource<TarArchiveEntry>> iterator() {
        return new Iterator<ArchiveEntrySource<TarArchiveEntry>>(){
            Object next;

            @Override
            public boolean hasNext() {
                if (null != this.next) {
                    return true;
                }
                try {
                    TarArchiveEntry entry;
                    while (null != (entry = TarArchiveInputStreamAdapter.this.tar.getNextTarEntry())) {
                        if (!ArchiveEntryNames.isInternal((String)entry.getName())) continue;
                        this.next = entry;
                        return true;
                    }
                }
                catch (IOException e) {
                    this.next = e;
                    return true;
                }
                return false;
            }

            @Override
            public ArchiveEntrySource<TarArchiveEntry> next() {
                if (this.hasNext()) {
                    if (this.next instanceof TarArchiveEntry) {
                        TarArchiveEntry entry = (TarArchiveEntry)this.next;
                        this.next = null;
                        return TarArchiveInputStreamAdapter.this.source(entry);
                    }
                    if (this.next instanceof Exception) {
                        throw (NoSuchElementException)new NoSuchElementException(this.next.toString()).initCause((Exception)this.next);
                    }
                }
                throw new NoSuchElementException();
            }
        };
    }

    public Optional<ArchiveEntrySource<TarArchiveEntry>> source(String name) {
        throw new UnsupportedOperationException();
    }

    private ArchiveEntrySource<TarArchiveEntry> source(final TarArchiveEntry entry) {
        return new ArchiveEntrySource<TarArchiveEntry>(){

            public String name() {
                return entry.getName();
            }

            public long size() {
                return entry.getSize();
            }

            public boolean isDirectory() {
                return entry.isDirectory();
            }

            public TarArchiveEntry entry() {
                return entry;
            }

            public Socket<InputStream> input() {
                return () -> {
                    if (entry != TarArchiveInputStreamAdapter.this.tar.getCurrentEntry()) {
                        throw new IllegalStateException("The TAR input stream is currently reading a different entry.");
                    }
                    return new UncloseableInputStream((InputStream)TarArchiveInputStreamAdapter.this.tar);
                };
            }
        };
    }

    public void close() throws IOException {
        this.tar.close();
    }
}

