/*
 * Decompiled with CFR 0.152.
 */
package global.namespace.fun.io.commons.compress;

import global.namespace.fun.io.api.ArchiveEntrySink;
import global.namespace.fun.io.api.ArchiveEntrySource;
import global.namespace.fun.io.api.ArchiveOutput;
import global.namespace.fun.io.api.Sink;
import global.namespace.fun.io.api.Socket;
import global.namespace.fun.io.spi.ArchiveEntryNames;
import global.namespace.fun.io.spi.Copy;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;

final class TarArchiveOutputStreamAdapter
implements ArchiveOutput<TarArchiveEntry> {
    private final TarArchiveOutputStream tar;

    TarArchiveOutputStreamAdapter(TarArchiveOutputStream tar) {
        this.tar = tar;
    }

    public boolean isJar() {
        return false;
    }

    public ArchiveEntrySink<TarArchiveEntry> sink(String name) {
        return this.sink(new TarArchiveEntry(ArchiveEntryNames.requireInternal((String)name)));
    }

    private ArchiveEntrySink<TarArchiveEntry> sink(final TarArchiveEntry entry) {
        return new ArchiveEntrySink<TarArchiveEntry>(){

            public String name() {
                return entry.getName();
            }

            public long size() {
                return entry.getSize();
            }

            public boolean isDirectory() {
                return entry.isDirectory();
            }

            public TarArchiveEntry entry() {
                return entry;
            }

            public Socket<OutputStream> output() {
                return () -> {
                    TarArchiveOutputStreamAdapter.this.tar.putArchiveEntry((ArchiveEntry)entry);
                    return new FilterOutputStream((OutputStream)TarArchiveOutputStreamAdapter.this.tar){
                        boolean closed;

                        @Override
                        public void close() throws IOException {
                            if (!this.closed) {
                                this.closed = true;
                                TarArchiveOutputStreamAdapter.this.tar.closeArchiveEntry();
                            }
                        }
                    };
                };
            }

            public void copyFrom(ArchiveEntrySource<?> source) throws Exception {
                entry.setSize(source.size());
                Copy.copy(source, (Sink)this);
            }
        };
    }

    public void close() throws IOException {
        this.tar.close();
    }
}

