/*
 * Decompiled with CFR 0.152.
 */
package global.namespace.fun.io.commons.compress;

import global.namespace.fun.io.api.ArchiveEntrySink;
import global.namespace.fun.io.api.ArchiveEntrySource;
import global.namespace.fun.io.api.ArchiveOutput;
import global.namespace.fun.io.api.Sink;
import global.namespace.fun.io.api.Socket;
import global.namespace.fun.io.commons.compress.ZipArchiveEntrySource;
import global.namespace.fun.io.spi.ArchiveEntryNames;
import global.namespace.fun.io.spi.Copy;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;

class ZipArchiveOutputStreamAdapter
implements ArchiveOutput<ZipArchiveEntry> {
    private final ZipArchiveOutputStream zip;

    ZipArchiveOutputStreamAdapter(ZipArchiveOutputStream zip) {
        this.zip = zip;
    }

    public boolean isJar() {
        return false;
    }

    public ArchiveEntrySink<ZipArchiveEntry> sink(String name) {
        return this.sink(new ZipArchiveEntry(ArchiveEntryNames.requireInternal((String)name)));
    }

    ArchiveEntrySink<ZipArchiveEntry> sink(final ZipArchiveEntry entry) {
        return new ArchiveEntrySink<ZipArchiveEntry>(){

            public String name() {
                return entry.getName();
            }

            public long size() {
                return entry.getSize();
            }

            public boolean isDirectory() {
                return entry.isDirectory();
            }

            public ZipArchiveEntry entry() {
                return entry;
            }

            public Socket<OutputStream> output() {
                return () -> {
                    if (entry.isDirectory()) {
                        entry.setMethod(0);
                        entry.setSize(0L);
                        entry.setCompressedSize(0L);
                        entry.setCrc(0L);
                    }
                    ZipArchiveOutputStreamAdapter.this.zip.putArchiveEntry((ArchiveEntry)entry);
                    return new FilterOutputStream((OutputStream)ZipArchiveOutputStreamAdapter.this.zip){
                        boolean closed;

                        @Override
                        public void close() throws IOException {
                            if (!this.closed) {
                                this.closed = true;
                                ZipArchiveOutputStreamAdapter.this.zip.closeArchiveEntry();
                            }
                        }
                    };
                };
            }

            public void copyFrom(ArchiveEntrySource<?> source) throws Exception {
                ZipArchiveEntrySource zipSource;
                ZipArchiveEntry origin;
                if (source instanceof ZipArchiveEntrySource && (origin = (ZipArchiveEntry)(zipSource = (ZipArchiveEntrySource)source).entry()).getName().equals(entry.getName())) {
                    zipSource.rawInput().accept(in -> ZipArchiveOutputStreamAdapter.this.zip.addRawArchiveEntry(origin, in));
                    return;
                }
                Copy.copy(source, (Sink)this);
            }
        };
    }

    public void close() throws IOException {
        this.zip.close();
    }
}

