/*
 * Decompiled with CFR 0.152.
 */
package global.namespace.fun.io.commons.compress;

import global.namespace.fun.io.api.ArchiveEntrySource;
import global.namespace.fun.io.api.ArchiveInput;
import global.namespace.fun.io.api.Socket;
import global.namespace.fun.io.commons.compress.ZipArchiveEntrySource;
import global.namespace.fun.io.spi.ArchiveEntryNames;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;

final class ZipFileAdapter
implements ArchiveInput<ZipArchiveEntry> {
    private final ZipFile zip;

    ZipFileAdapter(ZipFile zip) {
        this.zip = zip;
    }

    public Iterator<ArchiveEntrySource<ZipArchiveEntry>> iterator() {
        return new Iterator<ArchiveEntrySource<ZipArchiveEntry>>(){
            final Enumeration<ZipArchiveEntry> en;
            ZipArchiveEntry next;
            {
                this.en = ZipFileAdapter.this.zip.getEntries();
            }

            @Override
            public boolean hasNext() {
                if (null != this.next) {
                    return true;
                }
                while (this.en.hasMoreElements()) {
                    ZipArchiveEntry entry = this.en.nextElement();
                    if (!ArchiveEntryNames.isInternal((String)entry.getName())) continue;
                    this.next = entry;
                    return true;
                }
                return false;
            }

            @Override
            public ArchiveEntrySource<ZipArchiveEntry> next() {
                if (this.hasNext()) {
                    ZipArchiveEntry entry = this.next;
                    this.next = null;
                    return ZipFileAdapter.this.source(entry);
                }
                throw new NoSuchElementException();
            }
        };
    }

    public Optional<ArchiveEntrySource<ZipArchiveEntry>> source(String name) {
        return Optional.ofNullable(this.zip.getEntry(ArchiveEntryNames.requireInternal((String)name))).map(this::source);
    }

    private ZipArchiveEntrySource source(final ZipArchiveEntry entry) {
        return new ZipArchiveEntrySource(){

            public String name() {
                return entry.getName();
            }

            public long size() {
                return entry.getSize();
            }

            public boolean isDirectory() {
                return entry.isDirectory();
            }

            public ZipArchiveEntry entry() {
                return entry;
            }

            public Socket<InputStream> input() {
                return () -> ZipFileAdapter.this.zip.getInputStream(entry);
            }

            @Override
            Socket<InputStream> rawInput() {
                return () -> ZipFileAdapter.this.zip.getRawInputStream(entry);
            }
        };
    }

    public void close() throws IOException {
        this.zip.close();
    }
}

