/*
 * Decompiled with CFR 0.152.
 */
package global.namespace.fun.io.delta;

import global.namespace.fun.io.api.ArchiveEntrySource;
import global.namespace.fun.io.api.ArchiveInput;
import global.namespace.fun.io.api.ArchiveOutput;
import global.namespace.fun.io.api.ArchiveSink;
import global.namespace.fun.io.api.ArchiveSource;
import global.namespace.fun.io.api.Source;
import global.namespace.fun.io.api.function.XFunction;
import global.namespace.fun.io.delta.Delta;
import global.namespace.fun.io.delta.WithMessageDigest;
import global.namespace.fun.io.delta.model.DeltaModel;
import global.namespace.fun.io.delta.model.EntryNameAndDigestValue;
import global.namespace.fun.io.delta.model.EntryNameAndTwoDigestValues;
import java.security.MessageDigest;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;

abstract class ArchiveDiff<B, U>
implements WithMessageDigest {
    ArchiveDiff() {
    }

    @Override
    public abstract MessageDigest digest();

    abstract ArchiveSource<B> baseSource();

    abstract ArchiveSource<U> updateSource();

    DeltaModel toModel() throws Exception {
        return (DeltaModel)this.apply(Engine::toModel);
    }

    <D> void to(ArchiveSink<D> delta) throws Exception {
        this.apply(engine -> {
            delta.acceptWriter(engine::to);
            return null;
        });
    }

    private <D, T> T apply(XFunction<Engine<D>, T> function) throws Exception {
        return (T)this.baseSource().applyReader(baseInput -> this.updateSource().applyReader(updateInput -> function.apply((Object)new Engine<D>((ArchiveInput)baseInput, (ArchiveInput)updateInput){
            final /* synthetic */ ArchiveInput val$baseInput;
            final /* synthetic */ ArchiveInput val$updateInput;
            {
                this.val$baseInput = archiveInput;
                this.val$updateInput = archiveInput2;
            }

            @Override
            ArchiveInput<B> baseInput() {
                return this.val$baseInput;
            }

            @Override
            ArchiveInput<U> updateInput() {
                return this.val$updateInput;
            }
        })));
    }

    private abstract class Engine<D> {
        private Engine() {
        }

        abstract ArchiveInput<B> baseInput();

        abstract ArchiveInput<U> updateInput();

        void to(final ArchiveOutput<D> deltaOutput) throws Exception {
            final class Streamer {
                private final DeltaModel model;

                Streamer() throws Exception {
                    this.model = Engine.this.toModel();
                    Delta.encodeModel(deltaOutput, this.model);
                }

                private void stream() throws Exception {
                    for (ArchiveEntrySource updateEntry : Engine.this.updateInput()) {
                        String name = updateEntry.name();
                        if (!this.changedOrAdded(name)) continue;
                        updateEntry.copyTo(deltaOutput.sink(name));
                    }
                }

                private boolean changedOrAdded(String name) {
                    return null != this.model.changed(name) || null != this.model.added(name);
                }
            }
            new Streamer().stream();
        }

        DeltaModel toModel() throws Exception {
            Assembly assembly = new Assembly();
            for (ArchiveEntrySource baseEntry : this.baseInput()) {
                if (baseEntry.isDirectory()) continue;
                Optional updateEntry = this.updateInput().source(baseEntry.name());
                if (updateEntry.isPresent()) {
                    assembly.visitEntriesInBothFiles(baseEntry, (ArchiveEntrySource)updateEntry.get());
                    continue;
                }
                assembly.visitEntryInBaseFile(baseEntry);
            }
            for (ArchiveEntrySource updateEntry : this.updateInput()) {
                Optional baseEntry;
                if (updateEntry.isDirectory() || (baseEntry = this.baseInput().source(updateEntry.name())).isPresent()) continue;
                assembly.visitEntryInUpdateFile(updateEntry);
            }
            return assembly.deltaModel();
        }

        class Assembly {
            final Map<String, EntryNameAndTwoDigestValues> changed = new TreeMap<String, EntryNameAndTwoDigestValues>();
            final Map<String, EntryNameAndDigestValue> unchanged = new TreeMap<String, EntryNameAndDigestValue>();
            final Map<String, EntryNameAndDigestValue> added = new TreeMap<String, EntryNameAndDigestValue>();
            final Map<String, EntryNameAndDigestValue> removed = new TreeMap<String, EntryNameAndDigestValue>();

            Assembly() {
            }

            DeltaModel deltaModel() {
                return DeltaModel.builder().messageDigest(ArchiveDiff.this.digest()).changedEntries(this.changed.values()).unchangedEntries(this.unchanged.values()).addedEntries(this.added.values()).removedEntries(this.removed.values()).build();
            }

            void visitEntriesInBothFiles(ArchiveEntrySource<B> baseEntry, ArchiveEntrySource<U> updateEntry) throws Exception {
                String updateValue;
                String name = baseEntry.name();
                assert (name.equals(updateEntry.name()));
                String baseValue = ArchiveDiff.this.digestValueOf((Source)baseEntry);
                if (baseValue.equals(updateValue = ArchiveDiff.this.digestValueOf((Source)updateEntry))) {
                    this.unchanged.put(name, new EntryNameAndDigestValue(name, baseValue));
                } else {
                    this.changed.put(name, new EntryNameAndTwoDigestValues(name, baseValue, updateValue));
                }
            }

            void visitEntryInBaseFile(ArchiveEntrySource<B> baseEntry) throws Exception {
                String name = baseEntry.name();
                this.removed.put(name, new EntryNameAndDigestValue(name, ArchiveDiff.this.digestValueOf((Source)baseEntry)));
            }

            void visitEntryInUpdateFile(ArchiveEntrySource<U> updateEntry) throws Exception {
                String name = updateEntry.name();
                this.added.put(name, new EntryNameAndDigestValue(name, ArchiveDiff.this.digestValueOf((Source)updateEntry)));
            }
        }
    }
}

