/*
 * Decompiled with CFR 0.152.
 */
package global.namespace.fun.io.delta;

import global.namespace.fun.io.api.ArchiveSink;
import global.namespace.fun.io.api.ArchiveSource;
import global.namespace.fun.io.delta.ArchiveDiff;
import global.namespace.fun.io.delta.MessageDigests;
import global.namespace.fun.io.delta.model.DeltaModel;
import java.security.MessageDigest;
import java.util.Optional;

public final class ArchiveDiffBuilder {
    private Optional<MessageDigest> digest = Optional.empty();
    private Optional<ArchiveSource<?>> base = Optional.empty();
    private Optional<ArchiveSource<?>> update = Optional.empty();

    ArchiveDiffBuilder() {
    }

    public ArchiveDiffBuilder digest(MessageDigest digest) {
        this.digest = Optional.of(digest);
        return this;
    }

    public ArchiveDiffBuilder first(ArchiveSource<?> base) {
        return this.base(base);
    }

    public ArchiveDiffBuilder base(ArchiveSource<?> base) {
        this.base = Optional.of(base);
        return this;
    }

    public ArchiveDiffBuilder second(ArchiveSource<?> update) {
        return this.update(update);
    }

    public ArchiveDiffBuilder update(ArchiveSource<?> update) {
        this.update = Optional.of(update);
        return this;
    }

    public DeltaModel deltaModel() throws Exception {
        return this.toModel();
    }

    public DeltaModel toModel() throws Exception {
        return this.build().toModel();
    }

    public void to(ArchiveSink<?> delta) throws Exception {
        this.build().to(delta);
    }

    private ArchiveDiff<?, ?> build() {
        return ArchiveDiffBuilder.create(this.digest.orElseGet(MessageDigests::sha1), this.base.get(), this.update.get());
    }

    private static <B, U> ArchiveDiff<B, U> create(final MessageDigest digest, final ArchiveSource<B> baseSource, final ArchiveSource<U> updateSource) {
        return new ArchiveDiff<B, U>(){

            @Override
            public MessageDigest digest() {
                return digest;
            }

            @Override
            ArchiveSource<B> baseSource() {
                return baseSource;
            }

            @Override
            ArchiveSource<U> updateSource() {
                return updateSource;
            }
        };
    }
}

