/*
 * Decompiled with CFR 0.152.
 */
package global.namespace.fun.io.delta;

import global.namespace.fun.io.api.ArchiveEntrySource;
import global.namespace.fun.io.api.ArchiveInput;
import global.namespace.fun.io.api.ArchiveOutput;
import global.namespace.fun.io.api.ArchiveSink;
import global.namespace.fun.io.api.ArchiveSource;
import global.namespace.fun.io.api.Source;
import global.namespace.fun.io.api.function.XConsumer;
import global.namespace.fun.io.delta.Delta;
import global.namespace.fun.io.delta.InvalidDeltaArchiveFileException;
import global.namespace.fun.io.delta.MissingArchiveEntryException;
import global.namespace.fun.io.delta.WithMessageDigest;
import global.namespace.fun.io.delta.WrongBaseArchiveFileException;
import global.namespace.fun.io.delta.WrongMessageDigestException;
import global.namespace.fun.io.delta.model.DeltaModel;
import global.namespace.fun.io.delta.model.EntryNameAndDigestValue;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;

abstract class ArchivePatch<B, D> {
    ArchivePatch() {
    }

    abstract ArchiveSource<B> baseSource();

    abstract ArchiveSource<D> deltaSource();

    <U> void to(ArchiveSink<U> update) throws Exception {
        this.accept(engine -> update.acceptWriter(engine::to));
    }

    private <U> void accept(XConsumer<Engine<U>> consumer) throws Exception {
        this.baseSource().acceptReader(baseInput -> this.deltaSource().acceptReader(deltaInput -> consumer.accept((Object)new Engine<U>((ArchiveInput)baseInput, (ArchiveInput)deltaInput){
            final /* synthetic */ ArchiveInput val$baseInput;
            final /* synthetic */ ArchiveInput val$deltaInput;
            {
                this.val$baseInput = archiveInput;
                this.val$deltaInput = archiveInput2;
            }

            @Override
            ArchiveInput<B> baseInput() {
                return this.val$baseInput;
            }

            @Override
            ArchiveInput<D> deltaInput() {
                return this.val$deltaInput;
            }
        })));
    }

    private abstract class Engine<U> {
        DeltaModel model;
        WithMessageDigest digest;

        private Engine() {
        }

        abstract ArchiveInput<B> baseInput();

        abstract ArchiveInput<D> deltaInput();

        void to(ArchiveOutput<U> updateOutput) throws Exception {
            for (Predicate<String> filter : this.passFilters(updateOutput)) {
                this.to(updateOutput, filter);
            }
        }

        Iterable<Predicate<String>> passFilters(ArchiveOutput<U> updateOutput) {
            if (updateOutput.isJar()) {
                Predicate<String> manifestFilter = "META-INF/MANIFEST.MF"::equals;
                return Arrays.asList(manifestFilter, manifestFilter.negate());
            }
            return Collections.singletonList(t -> true);
        }

        void to(final ArchiveOutput<U> updateOutput, final Predicate<String> filter) throws Exception {
            class OnBaseInputPatch
            extends 1Patch<B> {
                OnBaseInputPatch() {
                    abstract class Patch<E> {
                        final /* synthetic */ Predicate val$filter;
                        final /* synthetic */ ArchiveOutput val$updateOutput;

                        Patch() {
                            this.val$filter = predicate;
                            this.val$updateOutput = archiveOutput;
                        }

                        abstract ArchiveInput<E> input();

                        abstract IOException ioException(Throwable var1);

                        final void apply(Collection<EntryNameAndDigestValue> collection) throws Exception {
                            for (EntryNameAndDigestValue entryNameAndDigestValue : collection) {
                                String name = entryNameAndDigestValue.name();
                                if (!this.val$filter.test(name)) continue;
                                Optional optEntry = this.input().source(name);
                                if (optEntry.isPresent()) {
                                    ArchiveEntrySource entry = (ArchiveEntrySource)optEntry.get();
                                    if (!Engine.this.digestValueOf((Source)entry).equals(entryNameAndDigestValue.digestValue())) {
                                        throw this.ioException(new WrongMessageDigestException(name));
                                    }
                                    entry.copyTo(this.val$updateOutput.sink(name));
                                    continue;
                                }
                                throw this.ioException(new MissingArchiveEntryException(name));
                            }
                        }
                    }
                    super(Engine.this, predicate, archiveOutput);
                }

                @Override
                ArchiveInput<B> input() {
                    return Engine.this.baseInput();
                }

                @Override
                IOException ioException(Throwable cause) {
                    return new WrongBaseArchiveFileException(cause);
                }
            }
            new OnBaseInputPatch().apply(this.model().unchangedEntries());
            class OnDeltaInputPatch
            extends 1Patch<D> {
                OnDeltaInputPatch() {
                    super(Engine.this, predicate, archiveOutput);
                }

                @Override
                ArchiveInput<D> input() {
                    return Engine.this.deltaInput();
                }

                @Override
                IOException ioException(Throwable cause) {
                    return new InvalidDeltaArchiveFileException(cause);
                }
            }
            new OnDeltaInputPatch().apply(this.model().changedEntries().stream().map(change -> new EntryNameAndDigestValue(change.name(), change.updateDigestValue())).collect(Collectors.toList()));
            new OnDeltaInputPatch().apply(this.model().addedEntries());
        }

        String digestValueOf(Source source) throws Exception {
            return this.digest().digestValueOf(source);
        }

        WithMessageDigest digest() throws Exception {
            WithMessageDigest digest = this.digest;
            return null != digest ? digest : (this.digest = WithMessageDigest.of(MessageDigest.getInstance(this.model().digestAlgorithmName())));
        }

        DeltaModel model() throws Exception {
            DeltaModel model = this.model;
            return null != model ? model : (this.model = Delta.decodeModel(this.deltaInput()));
        }
    }
}

