/*
 * Decompiled with CFR 0.152.
 */
package global.namespace.fun.io.delta;

import global.namespace.fun.io.api.ArchiveSink;
import global.namespace.fun.io.api.ArchiveSource;
import global.namespace.fun.io.delta.ArchivePatch;
import java.util.Optional;

public final class ArchivePatchBuilder {
    private Optional<ArchiveSource<?>> base = Optional.empty();
    private Optional<ArchiveSource<?>> delta = Optional.empty();

    ArchivePatchBuilder() {
    }

    public ArchivePatchBuilder first(ArchiveSource<?> base) {
        return this.base(base);
    }

    public ArchivePatchBuilder base(ArchiveSource<?> base) {
        this.base = Optional.of(base);
        return this;
    }

    public ArchivePatchBuilder delta(ArchiveSource<?> delta) {
        this.delta = Optional.of(delta);
        return this;
    }

    public void to(ArchiveSink<?> update) throws Exception {
        this.build().to(update);
    }

    private ArchivePatch<?, ?> build() {
        return ArchivePatchBuilder.create(this.base.get(), this.delta.get());
    }

    private static <B, D> ArchivePatch<B, D> create(final ArchiveSource<B> baseSource, final ArchiveSource<D> deltaSource) {
        return new ArchivePatch<B, D>(){

            @Override
            ArchiveSource<B> baseSource() {
                return baseSource;
            }

            @Override
            ArchiveSource<D> deltaSource() {
                return deltaSource;
            }
        };
    }
}

