/*
 * Decompiled with CFR 0.152.
 */
package global.namespace.fun.io.delta;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import global.namespace.fun.io.api.ArchiveInput;
import global.namespace.fun.io.api.ArchiveOutput;
import global.namespace.fun.io.api.Codec;
import global.namespace.fun.io.api.Sink;
import global.namespace.fun.io.api.Source;
import global.namespace.fun.io.delta.ArchiveDiffBuilder;
import global.namespace.fun.io.delta.ArchivePatchBuilder;
import global.namespace.fun.io.delta.InvalidDeltaArchiveFileException;
import global.namespace.fun.io.delta.MissingArchiveEntryException;
import global.namespace.fun.io.delta.dto.DeltaDTO;
import global.namespace.fun.io.delta.dto.EntryNameAndDigestValueDTO;
import global.namespace.fun.io.delta.dto.EntryNameAndTwoDigestValuesDTO;
import global.namespace.fun.io.delta.model.DeltaModel;
import global.namespace.fun.io.delta.model.EntryNameAndDigestValue;
import global.namespace.fun.io.delta.model.EntryNameAndTwoDigestValues;
import global.namespace.fun.io.jackson.Jackson;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public final class Delta {
    private static final String META_INF_DELTA_JSON = "META-INF/delta.json";

    private Delta() {
    }

    public static ArchiveDiffBuilder diff() {
        return new ArchiveDiffBuilder();
    }

    public static ArchivePatchBuilder patch() {
        return new ArchivePatchBuilder();
    }

    static <E> void encodeModel(ArchiveOutput<E> output, DeltaModel model) throws Exception {
        Delta.encodeModel((Sink)output.sink(META_INF_DELTA_JSON), model);
    }

    static <E> DeltaModel decodeModel(ArchiveInput<E> input) throws Exception {
        return Delta.decodeModel((Source)input.source(META_INF_DELTA_JSON).orElseThrow(() -> new InvalidDeltaArchiveFileException(new MissingArchiveEntryException(META_INF_DELTA_JSON))));
    }

    static void encodeModel(Sink sink, DeltaModel model) throws Exception {
        Delta.encodeDTO(sink, Delta.marshal(model));
    }

    static DeltaModel decodeModel(Source source) throws Exception {
        return Delta.unmarshal(Delta.decodeDTO(source));
    }

    private static void encodeDTO(Sink sink, DeltaDTO dto) throws Exception {
        Delta.jsonCodec().encoder(sink).encode((Object)dto);
    }

    private static DeltaDTO decodeDTO(Source source) throws Exception {
        return (DeltaDTO)Delta.jsonCodec().decoder(source).decode(DeltaDTO.class);
    }

    private static Codec jsonCodec() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_DEFAULT);
        return Jackson.json((ObjectMapper)mapper);
    }

    private static DeltaDTO marshal(DeltaModel model) {
        if (null == model) {
            return null;
        }
        DeltaDTO dto = new DeltaDTO();
        dto.algorithm = model.digestAlgorithmName();
        dto.numBytes = model.digestByteLength().orElse(0);
        dto.changed = Delta.marshal2(model.changedEntries());
        dto.unchanged = Delta.marshal(model.unchangedEntries());
        dto.added = Delta.marshal(model.addedEntries());
        dto.removed = Delta.marshal(model.removedEntries());
        return dto;
    }

    private static DeltaModel unmarshal(DeltaDTO dto) throws Exception {
        if (null == dto) {
            return null;
        }
        return DeltaModel.builder().messageDigest(MessageDigest.getInstance(dto.algorithm)).changedEntries(Delta.unmarshal2(dto.changed)).unchangedEntries(Delta.unmarshal(dto.unchanged)).addedEntries(Delta.unmarshal(dto.added)).removedEntries(Delta.unmarshal(dto.removed)).build();
    }

    private static EntryNameAndTwoDigestValuesDTO[] marshal2(Collection<EntryNameAndTwoDigestValues> c) {
        if (null == c || c.isEmpty()) {
            return null;
        }
        return (EntryNameAndTwoDigestValuesDTO[])c.stream().map(values -> {
            EntryNameAndTwoDigestValuesDTO dto = new EntryNameAndTwoDigestValuesDTO();
            dto.name = values.name();
            dto.first = values.baseDigestValue();
            dto.second = values.updateDigestValue();
            return dto;
        }).toArray(EntryNameAndTwoDigestValuesDTO[]::new);
    }

    private static List<EntryNameAndTwoDigestValues> unmarshal2(EntryNameAndTwoDigestValuesDTO[] c) {
        return null == c ? Collections.emptyList() : Arrays.stream(c).map(dto -> new EntryNameAndTwoDigestValues(dto.name, dto.first, dto.second)).collect(Collectors.toList());
    }

    private static EntryNameAndDigestValueDTO[] marshal(Collection<EntryNameAndDigestValue> c) {
        if (null == c || c.isEmpty()) {
            return null;
        }
        return (EntryNameAndDigestValueDTO[])c.stream().map(value -> {
            EntryNameAndDigestValueDTO dto = new EntryNameAndDigestValueDTO();
            dto.name = value.name();
            dto.digest = value.digestValue();
            return dto;
        }).toArray(EntryNameAndDigestValueDTO[]::new);
    }

    private static List<EntryNameAndDigestValue> unmarshal(EntryNameAndDigestValueDTO[] c) {
        return null == c ? Collections.emptyList() : Arrays.stream(c).map(dto -> new EntryNameAndDigestValue(dto.name, dto.digest)).collect(Collectors.toList());
    }
}

