/*
 * Decompiled with CFR 0.152.
 */
package global.namespace.fun.io.delta;

import global.namespace.fun.io.api.Source;
import java.math.BigInteger;
import java.security.MessageDigest;

interface WithMessageDigest {
    public static WithMessageDigest of(MessageDigest digest) {
        return () -> digest;
    }

    public MessageDigest digest();

    default public String digestValueOf(Source source) throws Exception {
        return (String)source.applyReader(in -> {
            int read;
            MessageDigest digest = this.digest();
            digest.reset();
            byte[] buffer = new byte[8192];
            while (0 <= (read = in.read(buffer))) {
                digest.update(buffer, 0, read);
            }
            return new BigInteger(1, digest.digest()).toString(16);
        });
    }
}

