/*
 * Decompiled with CFR 0.152.
 */
package global.namespace.fun.io.delta.model;

import global.namespace.fun.io.delta.model.EntryNameAndDigestValue;
import global.namespace.fun.io.delta.model.EntryNameAndTwoDigestValues;
import global.namespace.fun.io.delta.model.HashMaps;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class DeltaModel {
    private final String digestAlgorithmName;
    private final Optional<Integer> digestByteLength;
    private final Map<String, EntryNameAndTwoDigestValues> changed;
    private final Map<String, EntryNameAndDigestValue> unchanged;
    private final Map<String, EntryNameAndDigestValue> added;
    private final Map<String, EntryNameAndDigestValue> removed;

    private DeltaModel(Builder b) {
        MessageDigest digest = (MessageDigest)b.messageDigest.get();
        this.digestAlgorithmName = digest.getAlgorithm();
        this.digestByteLength = DeltaModel.lengthBytes(digest);
        this.changed = DeltaModel.changedMap(b.changed);
        this.unchanged = DeltaModel.unchangedMap(b.unchanged);
        this.added = DeltaModel.unchangedMap(b.added);
        this.removed = DeltaModel.unchangedMap(b.removed);
    }

    public static Builder builder() {
        return new Builder();
    }

    private static Optional<Integer> lengthBytes(MessageDigest digest) {
        MessageDigest clone;
        try {
            clone = MessageDigest.getInstance(digest.getAlgorithm());
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
        if (clone.getDigestLength() == digest.getDigestLength()) {
            return Optional.empty();
        }
        return Optional.of(digest.getDigestLength());
    }

    private static Map<String, EntryNameAndTwoDigestValues> changedMap(Collection<EntryNameAndTwoDigestValues> entries) {
        LinkedHashMap<String, EntryNameAndTwoDigestValues> map = new LinkedHashMap<String, EntryNameAndTwoDigestValues>(DeltaModel.initialCapacity(entries));
        for (EntryNameAndTwoDigestValues entryNameAndTwoDigestValues : entries) {
            map.put(entryNameAndTwoDigestValues.name(), entryNameAndTwoDigestValues);
        }
        return Collections.unmodifiableMap(map);
    }

    private static Map<String, EntryNameAndDigestValue> unchangedMap(Collection<EntryNameAndDigestValue> entries) {
        LinkedHashMap<String, EntryNameAndDigestValue> map = new LinkedHashMap<String, EntryNameAndDigestValue>(DeltaModel.initialCapacity(entries));
        for (EntryNameAndDigestValue entryNameAndDigestValue : entries) {
            map.put(entryNameAndDigestValue.name(), entryNameAndDigestValue);
        }
        return Collections.unmodifiableMap(map);
    }

    private static int initialCapacity(Collection<?> c) {
        return HashMaps.initialCapacity(c.size());
    }

    public String digestAlgorithmName() {
        return this.digestAlgorithmName;
    }

    public Optional<Integer> digestByteLength() {
        return this.digestByteLength;
    }

    public Collection<EntryNameAndTwoDigestValues> changedEntries() {
        return this.changed.values();
    }

    public EntryNameAndTwoDigestValues changed(String name) {
        return this.changed.get(name);
    }

    public Collection<EntryNameAndDigestValue> unchangedEntries() {
        return this.unchanged.values();
    }

    public EntryNameAndDigestValue unchanged(String name) {
        return this.unchanged.get(name);
    }

    public Collection<EntryNameAndDigestValue> addedEntries() {
        return this.added.values();
    }

    public EntryNameAndDigestValue added(String name) {
        return this.added.get(name);
    }

    public Collection<EntryNameAndDigestValue> removedEntries() {
        return this.removed.values();
    }

    public EntryNameAndDigestValue removed(String name) {
        return this.removed.get(name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DeltaModel)) {
            return false;
        }
        DeltaModel that = (DeltaModel)obj;
        return this.digestAlgorithmName.equals(that.digestAlgorithmName) && this.digestByteLength.equals(that.digestByteLength) && this.changed.equals(that.changed) && this.unchanged.equals(that.unchanged) && this.added.equals(that.added) && this.removed.equals(that.removed);
    }

    public int hashCode() {
        int hash = 17;
        hash = 31 * hash + this.digestAlgorithmName.hashCode();
        hash = 31 * hash + this.digestByteLength.hashCode();
        hash = 31 * hash + this.changed.hashCode();
        hash = 31 * hash + this.unchanged.hashCode();
        hash = 31 * hash + this.added.hashCode();
        hash = 31 * hash + this.removed.hashCode();
        return hash;
    }

    public static final class Builder {
        private Optional<MessageDigest> messageDigest = Optional.empty();
        private Collection<EntryNameAndTwoDigestValues> changed = Collections.emptyList();
        private Collection<EntryNameAndDigestValue> unchanged = Collections.emptyList();
        private Collection<EntryNameAndDigestValue> added = Collections.emptyList();
        private Collection<EntryNameAndDigestValue> removed = Collections.emptyList();

        private Builder() {
        }

        public Builder messageDigest(MessageDigest messageDigest) {
            this.messageDigest = Optional.of(messageDigest);
            return this;
        }

        public Builder changedEntries(Collection<EntryNameAndTwoDigestValues> changed) {
            this.changed = Objects.requireNonNull(changed);
            return this;
        }

        public Builder unchangedEntries(Collection<EntryNameAndDigestValue> unchanged) {
            this.unchanged = Objects.requireNonNull(unchanged);
            return this;
        }

        public Builder addedEntries(Collection<EntryNameAndDigestValue> added) {
            this.added = Objects.requireNonNull(added);
            return this;
        }

        public Builder removedEntries(Collection<EntryNameAndDigestValue> removed) {
            this.removed = Objects.requireNonNull(removed);
            return this;
        }

        public DeltaModel build() {
            return new DeltaModel(this);
        }
    }
}

