/*
 * Decompiled with CFR 0.152.
 */
package gr.james.simplegraph;

import gr.james.simplegraph.BaseGraph;
import gr.james.simplegraph.DirectedGraph;
import gr.james.simplegraph.Graph;
import gr.james.simplegraph.WeightedDirectedGraph;
import gr.james.simplegraph.WeightedGraph;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class Graphs {
    private Graphs() {
    }

    public static boolean isWeightLegal(double weight) {
        return !Double.isNaN(weight) && !Double.isInfinite(weight);
    }

    public static double requireWeightLegal(double weight) {
        if (!Graphs.isWeightLegal(weight)) {
            throw new IllegalArgumentException();
        }
        return weight;
    }

    public static boolean isVertexInGraph(BaseGraph g, int v) {
        return v >= 0 && v < g.size();
    }

    public static int requireVertexInGraph(BaseGraph g, int v) {
        if (!Graphs.isVertexInGraph(g, v)) {
            throw new IndexOutOfBoundsException();
        }
        return v;
    }

    public static void requireEdgeExists(Graph g, int v, int w) {
        Graphs.requireVertexInGraph(g, w);
        if (!g.getEdges(v).contains(w)) {
            throw new IllegalArgumentException();
        }
    }

    public static void requireEdgeExists(WeightedGraph g, int v, int w) {
        Graphs.requireEdgeExists(g.asGraph(), v, w);
    }

    public static void requireEdgeExists(DirectedGraph g, int source, int target) {
        Graphs.requireVertexInGraph(g, target);
        if (!g.getOutEdges(source).contains(target)) {
            throw new IllegalArgumentException();
        }
    }

    public static void requireEdgeExists(WeightedDirectedGraph g, int source, int target) {
        Graphs.requireEdgeExists(g.asDirected(), source, target);
    }

    public static boolean equals(Graph a, Graph b) {
        if (a.size() != b.size()) {
            return false;
        }
        for (int i = 0; i < a.size(); ++i) {
            if (a.getEdges(i).equals(b.getEdges(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(DirectedGraph a, DirectedGraph b) {
        if (a.size() != b.size()) {
            return false;
        }
        for (int i = 0; i < a.size(); ++i) {
            if (a.getOutEdges(i).equals(b.getOutEdges(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(WeightedGraph a, WeightedGraph b) {
        if (a.size() != b.size()) {
            return false;
        }
        for (int i = 0; i < a.size(); ++i) {
            if (!a.getEdges(i).equals(b.getEdges(i))) {
                return false;
            }
            for (int j : a.getEdges(i)) {
                if (a.getEdgeWeight(i, j) == b.getEdgeWeight(i, j)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean equals(WeightedDirectedGraph a, WeightedDirectedGraph b) {
        if (a.size() != b.size()) {
            return false;
        }
        for (int i = 0; i < a.size(); ++i) {
            if (!a.getOutEdges(i).equals(b.getOutEdges(i))) {
                return false;
            }
            for (int j : a.getOutEdges(i)) {
                if (a.getEdgeWeight(i, j) == b.getEdgeWeight(i, j)) continue;
                return false;
            }
        }
        return true;
    }

    static <E> Iterator<E> emptyIterator() {
        return new Iterator<E>(){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public E next() {
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

