/*
 * Decompiled with CFR 0.152.
 */
package gr.james.simplegraph;

import gr.james.simplegraph.BipartiteGraph;
import gr.james.simplegraph.Edge;
import gr.james.simplegraph.Graph;
import gr.james.simplegraph.Graphs;
import gr.james.simplegraph.MutableDirectedGraph;
import gr.james.simplegraph.MutableGraph;
import gr.james.simplegraph.MutableWeightedDirectedGraph;
import gr.james.simplegraph.MutableWeightedGraph;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class MutableBipartiteGraph
implements BipartiteGraph {
    private static final long serialVersionUID = 1L;
    private final MutableGraph g = new MutableGraph();
    private final Set<Integer> a = new HashSet<Integer>();
    private final Set<Integer> b = new HashSet<Integer>();

    public MutableBipartiteGraph() {
    }

    public MutableBipartiteGraph(BipartiteGraph g) {
        this();
        for (int v = 0; v < g.size(); ++v) {
            assert (g.setA().contains(v) ^ g.setB().contains(v));
            if (g.setA().contains(v)) {
                this.addVertexInA();
                continue;
            }
            if (!g.setB().contains(v)) continue;
            this.addVertexInB();
        }
        for (Edge e : g.edges()) {
            boolean inserted = this.putEdge(e.v(), e.w());
            assert (inserted);
        }
        assert (g.equals(this));
    }

    @Override
    public int size() {
        assert (this.a.size() + this.b.size() == this.g.size());
        return this.g.size();
    }

    @Override
    public Set<Integer> setA() {
        return Collections.unmodifiableSet(this.a);
    }

    @Override
    public Set<Integer> setB() {
        return Collections.unmodifiableSet(this.a);
    }

    @Override
    public Set<Integer> getEdges(int v) {
        return this.g.getEdges(v);
    }

    @Override
    public final Iterable<Edge> edges() {
        return this.g.edges();
    }

    public void addVertexInA() {
        int newID = this.g.size();
        this.g.addVertex();
        this.a.add(newID);
    }

    public void addVertexInB() {
        int newID = this.g.size();
        this.g.addVertex();
        this.b.add(newID);
    }

    public void removeVertex(int v) {
        this.g.removeVertex(v);
        for (int i = v + 1; i < this.size(); ++i) {
            assert (this.a.contains(i) ^ this.a.contains(i));
            if (this.a.contains(i)) {
                this.a.remove(i);
                this.a.add(i - 1);
                continue;
            }
            if (!this.b.contains(i)) continue;
            this.b.remove(i);
            this.b.add(i - 1);
        }
    }

    public boolean putEdge(int v, int w) {
        if (this.a.contains(v) && this.a.contains(w)) {
            throw new UnsupportedOperationException();
        }
        if (this.b.contains(v) && this.b.contains(w)) {
            throw new UnsupportedOperationException();
        }
        return this.g.putEdge(v, w);
    }

    public boolean removeEdge(int v, int w) {
        return this.g.removeEdge(v, w);
    }

    public final BipartiteGraph toImmutable() {
        return new MutableBipartiteGraph(this).asUnmodifiable();
    }

    public final BipartiteGraph asUnmodifiable() {
        return new MutableBipartiteGraph(){

            @Override
            public int size() {
                return MutableBipartiteGraph.this.size();
            }

            @Override
            public Set<Integer> getEdges(int v) {
                return MutableBipartiteGraph.this.getEdges(v);
            }

            @Override
            public Set<Integer> setA() {
                return MutableBipartiteGraph.this.setA();
            }

            @Override
            public Set<Integer> setB() {
                return MutableBipartiteGraph.this.setB();
            }

            @Override
            public void addVertexInA() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void addVertexInB() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void removeVertex(int v) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean putEdge(int v, int w) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean removeEdge(int v, int w) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public final MutableDirectedGraph asDirected() {
        return new MutableDirectedGraph(){

            @Override
            public int size() {
                return MutableBipartiteGraph.this.size();
            }

            @Override
            public Set<Integer> getOutEdges(int v) {
                return MutableBipartiteGraph.this.getEdges(v);
            }

            @Override
            public Set<Integer> getInEdges(int v) {
                return MutableBipartiteGraph.this.getEdges(v);
            }

            @Override
            public void addVertex() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void removeVertex(int v) {
                MutableBipartiteGraph.this.removeVertex(v);
            }

            @Override
            public boolean putEdge(int source, int target) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean removeEdge(int source, int target) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public final MutableWeightedGraph asWeighted() {
        return new MutableWeightedGraph(){

            @Override
            public int size() {
                return MutableBipartiteGraph.this.size();
            }

            @Override
            public Set<Integer> getEdges(int v) {
                return MutableBipartiteGraph.this.getEdges(v);
            }

            @Override
            public double getEdgeWeight(int v, int w) {
                Graphs.requireEdgeExists(MutableBipartiteGraph.this, v, w);
                return 1.0;
            }

            @Override
            public void addVertex() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void removeVertex(int v) {
                MutableBipartiteGraph.this.removeVertex(v);
            }

            @Override
            public Double putEdge(int v, int w, double weight) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Double removeEdge(int v, int w) {
                return MutableBipartiteGraph.this.removeEdge(v, w) ? Double.valueOf(1.0) : null;
            }
        };
    }

    @Override
    public final MutableWeightedDirectedGraph asWeightedDirected() {
        return new MutableWeightedDirectedGraph(){

            @Override
            public int size() {
                return MutableBipartiteGraph.this.size();
            }

            @Override
            public Set<Integer> getOutEdges(int v) {
                return MutableBipartiteGraph.this.getEdges(v);
            }

            @Override
            public Set<Integer> getInEdges(int v) {
                return MutableBipartiteGraph.this.getEdges(v);
            }

            @Override
            public double getEdgeWeight(int source, int target) {
                Graphs.requireEdgeExists(MutableBipartiteGraph.this, source, target);
                return 1.0;
            }

            @Override
            public void addVertex() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void removeVertex(int v) {
                MutableBipartiteGraph.this.removeVertex(v);
            }

            @Override
            public Double putEdge(int source, int target, double weight) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Double removeEdge(int source, int target) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%s(%d,%d+%d) {%n", "BipartiteGraph", this.size(), this.setA().size(), this.setB().size()));
        for (Edge e : this.edges()) {
            if (this.setA().contains(e.v())) {
                sb.append(String.format("  %s%n", e));
                continue;
            }
            sb.append(String.format("  %s%n", e.swap()));
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof Graph)) {
            return false;
        }
        Graph that = (Graph)obj;
        return Graphs.equals(this, that);
    }

    @Override
    public final int hashCode() {
        return this.g.hashCode();
    }
}

