/*
 * Decompiled with CFR 0.152.
 */
package gr.james.simplegraph;

import gr.james.simplegraph.AbstractIterator;
import gr.james.simplegraph.DirectedEdge;
import gr.james.simplegraph.DirectedEdgeImpl;
import gr.james.simplegraph.DirectedGraph;
import gr.james.simplegraph.Graph;
import gr.james.simplegraph.Graphs;
import gr.james.simplegraph.MutableWeightedDirectedGraph;
import gr.james.simplegraph.WeightedDirectedGraph;
import gr.james.simplegraph.WeightedGraph;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class MutableDirectedGraph
implements DirectedGraph {
    private static final long serialVersionUID = 1L;
    private final List<Set<Integer>> outEdges;
    private final List<Set<Integer>> inEdges;

    public MutableDirectedGraph() {
        this.inEdges = new ArrayList<Set<Integer>>();
        this.outEdges = new ArrayList<Set<Integer>>();
    }

    public MutableDirectedGraph(int n) {
        this.inEdges = new ArrayList<Set<Integer>>(n);
        this.outEdges = new ArrayList<Set<Integer>>(n);
        this.addVertices(n);
        assert (this.size() == n);
    }

    public MutableDirectedGraph(DirectedGraph g) {
        this(g.size());
        for (DirectedEdge e : g.edges()) {
            this.putEdge(e.source(), e.target());
        }
        assert (g.equals(this));
    }

    public MutableDirectedGraph(WeightedDirectedGraph g) {
        this(g.asDirected());
    }

    public MutableDirectedGraph(WeightedGraph g) {
        this(g.asDirected());
    }

    public MutableDirectedGraph(Graph g) {
        this(g.asDirected());
    }

    @Override
    public int size() {
        assert (this.inEdges.size() == this.outEdges.size());
        return this.inEdges.size();
    }

    @Override
    public Set<Integer> getOutEdges(int v) {
        Set<Integer> edges = this.outEdges.get(v);
        return Collections.unmodifiableSet(edges);
    }

    @Override
    public Set<Integer> getInEdges(int v) {
        Set<Integer> edges = this.inEdges.get(v);
        return Collections.unmodifiableSet(edges);
    }

    @Override
    public final Iterable<DirectedEdge> edges() {
        return new Iterable<DirectedEdge>(){

            @Override
            public Iterator<DirectedEdge> iterator() {
                return new AbstractIterator<DirectedEdge>(){
                    private int currentVertex;
                    private Iterator<Integer> edges;

                    @Override
                    void init() {
                        this.currentVertex = -1;
                        this.edges = Graphs.emptyIterator();
                    }

                    @Override
                    DirectedEdge computeNext() {
                        while (true) {
                            if (this.currentVertex >= MutableDirectedGraph.this.size()) {
                                return null;
                            }
                            if (this.currentVertex == MutableDirectedGraph.this.size() - 1 && !this.edges.hasNext()) {
                                return null;
                            }
                            if (this.edges.hasNext()) break;
                            this.edges = MutableDirectedGraph.this.getOutEdges(++this.currentVertex).iterator();
                        }
                        int e = this.edges.next();
                        return new DirectedEdgeImpl(this.currentVertex, e);
                    }
                };
            }
        };
    }

    public void addVertex() {
        this.inEdges.add(new HashSet());
        this.outEdges.add(new HashSet());
    }

    public final void addVertices(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < n; ++i) {
            this.addVertex();
        }
    }

    public void removeVertex(int v) {
        Graphs.requireVertexInGraph(this, v);
        for (int i = 0; i < this.size(); ++i) {
            Set<Integer> previousOut = this.outEdges.get(i);
            HashSet<Integer> newOut = new HashSet<Integer>();
            for (Integer e : previousOut) {
                if (e > v) {
                    newOut.add(e - 1);
                    continue;
                }
                if (e >= v) continue;
                newOut.add(e);
            }
            this.outEdges.set(i, newOut);
            Set<Integer> previousIn = this.inEdges.get(i);
            HashSet<Integer> newIn = new HashSet<Integer>();
            for (Integer e : previousIn) {
                if (e > v) {
                    newIn.add(e - 1);
                    continue;
                }
                if (e >= v) continue;
                newIn.add(e);
            }
            this.inEdges.set(i, newIn);
        }
        this.outEdges.remove(v);
        this.inEdges.remove(v);
    }

    public boolean putEdge(int source, int target) {
        boolean a = this.outEdges.get(source).add(target);
        boolean b = this.inEdges.get(target).add(source);
        assert (a == b);
        return a;
    }

    public boolean removeEdge(int source, int target) {
        boolean a = this.outEdges.get(source).remove(target);
        boolean b = this.inEdges.get(target).remove(source);
        assert (a == b);
        return a;
    }

    public final DirectedGraph toImmutable() {
        return new MutableDirectedGraph(this).asUnmodifiable();
    }

    public final DirectedGraph asUnmodifiable() {
        return new MutableDirectedGraph(){

            @Override
            public int size() {
                return MutableDirectedGraph.this.size();
            }

            @Override
            public Set<Integer> getOutEdges(int v) {
                return MutableDirectedGraph.this.getOutEdges(v);
            }

            @Override
            public Set<Integer> getInEdges(int v) {
                return MutableDirectedGraph.this.getInEdges(v);
            }

            @Override
            public void addVertex() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void removeVertex(int v) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean putEdge(int source, int target) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean removeEdge(int source, int target) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public final MutableWeightedDirectedGraph asWeightedDirected() {
        return new MutableWeightedDirectedGraph(){

            @Override
            public int size() {
                return MutableDirectedGraph.this.size();
            }

            @Override
            public Set<Integer> getOutEdges(int v) {
                return MutableDirectedGraph.this.getOutEdges(v);
            }

            @Override
            public Set<Integer> getInEdges(int v) {
                return MutableDirectedGraph.this.getInEdges(v);
            }

            @Override
            public double getEdgeWeight(int source, int target) {
                Graphs.requireEdgeExists(MutableDirectedGraph.this, source, target);
                return 1.0;
            }

            @Override
            public void addVertex() {
                MutableDirectedGraph.this.addVertex();
            }

            @Override
            public void removeVertex(int v) {
                MutableDirectedGraph.this.removeVertex(v);
            }

            @Override
            public Double putEdge(int source, int target, double weight) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Double removeEdge(int source, int target) {
                return MutableDirectedGraph.this.removeEdge(source, target) ? Double.valueOf(1.0) : null;
            }
        };
    }

    @Override
    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%s(%d) {%n", "DirectedGraph", this.size()));
        for (DirectedEdge e : this.edges()) {
            sb.append(String.format("  %s%n", e));
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof DirectedGraph)) {
            return false;
        }
        DirectedGraph that = (DirectedGraph)obj;
        return Graphs.equals(this, that);
    }

    @Override
    public final int hashCode() {
        int hash = 1;
        for (int i = 0; i < this.size(); ++i) {
            hash = 31 * hash;
            for (int j : this.getOutEdges(i)) {
                hash += j;
            }
        }
        return hash;
    }
}

