/*
 * Decompiled with CFR 0.152.
 */
package gr.james.simplegraph;

import gr.james.simplegraph.AbstractIterator;
import gr.james.simplegraph.Edge;
import gr.james.simplegraph.EdgeImpl;
import gr.james.simplegraph.Graph;
import gr.james.simplegraph.Graphs;
import gr.james.simplegraph.MutableDirectedGraph;
import gr.james.simplegraph.MutableWeightedDirectedGraph;
import gr.james.simplegraph.MutableWeightedGraph;
import gr.james.simplegraph.WeightedGraph;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class MutableGraph
implements Graph {
    private static final long serialVersionUID = 1L;
    private final List<Set<Integer>> edges;

    public MutableGraph() {
        this.edges = new ArrayList<Set<Integer>>();
    }

    public MutableGraph(int n) {
        this.edges = new ArrayList<Set<Integer>>(n);
        this.addVertices(n);
        assert (this.size() == n);
    }

    public MutableGraph(Graph g) {
        this(g.size());
        for (Edge e : g.edges()) {
            this.putEdge(e.v(), e.w());
        }
        assert (g.equals(this));
    }

    public MutableGraph(WeightedGraph g) {
        this(g.asGraph());
    }

    @Override
    public int size() {
        return this.edges.size();
    }

    @Override
    public Set<Integer> getEdges(int v) {
        Set<Integer> edges = this.edges.get(v);
        return Collections.unmodifiableSet(edges);
    }

    @Override
    public final Iterable<Edge> edges() {
        return new Iterable<Edge>(){

            @Override
            public Iterator<Edge> iterator() {
                return new AbstractIterator<Edge>(){
                    private int currentVertex;
                    private Iterator<Integer> edges;

                    @Override
                    void init() {
                        this.currentVertex = -1;
                        this.edges = Graphs.emptyIterator();
                    }

                    @Override
                    Edge computeNext() {
                        int e;
                        while (true) {
                            if (this.currentVertex >= MutableGraph.this.size()) {
                                return null;
                            }
                            if (this.currentVertex == MutableGraph.this.size() - 1 && !this.edges.hasNext()) {
                                return null;
                            }
                            if (!this.edges.hasNext()) {
                                this.edges = MutableGraph.this.getEdges(++this.currentVertex).iterator();
                                continue;
                            }
                            e = this.edges.next();
                            if (e >= this.currentVertex) break;
                        }
                        return new EdgeImpl(this.currentVertex, e);
                    }
                };
            }
        };
    }

    public void addVertex() {
        this.edges.add(new HashSet());
    }

    public final void addVertices(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < n; ++i) {
            this.addVertex();
        }
    }

    public void removeVertex(int v) {
        Graphs.requireVertexInGraph(this, v);
        for (int i = 0; i < this.size(); ++i) {
            Set<Integer> previousOut = this.edges.get(i);
            HashSet<Integer> newOut = new HashSet<Integer>();
            for (Integer e : previousOut) {
                if (e > v) {
                    newOut.add(e - 1);
                    continue;
                }
                if (e >= v) continue;
                newOut.add(e);
            }
            this.edges.set(i, newOut);
        }
        this.edges.remove(v);
    }

    public boolean putEdge(int v, int w) {
        boolean a = this.edges.get(v).add(w);
        boolean b = this.edges.get(w).add(v);
        assert (a == b);
        return a;
    }

    public boolean removeEdge(int v, int w) {
        boolean a = this.edges.get(v).remove(w);
        boolean b = this.edges.get(w).remove(v);
        assert (a == b);
        return a;
    }

    public final Graph toImmutable() {
        return new MutableGraph(this).asUnmodifiable();
    }

    public final Graph asUnmodifiable() {
        return new MutableGraph(){

            @Override
            public int size() {
                return MutableGraph.this.size();
            }

            @Override
            public Set<Integer> getEdges(int v) {
                return MutableGraph.this.getEdges(v);
            }

            @Override
            public void addVertex() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void removeVertex(int v) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean putEdge(int v, int w) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean removeEdge(int v, int w) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public final MutableDirectedGraph asDirected() {
        return new MutableDirectedGraph(){

            @Override
            public int size() {
                return MutableGraph.this.size();
            }

            @Override
            public Set<Integer> getOutEdges(int v) {
                return MutableGraph.this.getEdges(v);
            }

            @Override
            public Set<Integer> getInEdges(int v) {
                return MutableGraph.this.getEdges(v);
            }

            @Override
            public void addVertex() {
                MutableGraph.this.addVertex();
            }

            @Override
            public void removeVertex(int v) {
                MutableGraph.this.removeVertex(v);
            }

            @Override
            public boolean putEdge(int source, int target) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean removeEdge(int source, int target) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public final MutableWeightedGraph asWeighted() {
        return new MutableWeightedGraph(){

            @Override
            public int size() {
                return MutableGraph.this.size();
            }

            @Override
            public Set<Integer> getEdges(int v) {
                return MutableGraph.this.getEdges(v);
            }

            @Override
            public double getEdgeWeight(int v, int w) {
                Graphs.requireEdgeExists(MutableGraph.this, v, w);
                return 1.0;
            }

            @Override
            public void addVertex() {
                MutableGraph.this.addVertex();
            }

            @Override
            public void removeVertex(int v) {
                MutableGraph.this.removeVertex(v);
            }

            @Override
            public Double putEdge(int v, int w, double weight) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Double removeEdge(int v, int w) {
                return MutableGraph.this.removeEdge(v, w) ? Double.valueOf(1.0) : null;
            }
        };
    }

    @Override
    public final MutableWeightedDirectedGraph asWeightedDirected() {
        return new MutableWeightedDirectedGraph(){

            @Override
            public int size() {
                return MutableGraph.this.size();
            }

            @Override
            public Set<Integer> getOutEdges(int v) {
                return MutableGraph.this.getEdges(v);
            }

            @Override
            public Set<Integer> getInEdges(int v) {
                return MutableGraph.this.getEdges(v);
            }

            @Override
            public double getEdgeWeight(int source, int target) {
                Graphs.requireEdgeExists(MutableGraph.this, source, target);
                return 1.0;
            }

            @Override
            public void addVertex() {
                MutableGraph.this.addVertex();
            }

            @Override
            public void removeVertex(int v) {
                MutableGraph.this.removeVertex(v);
            }

            @Override
            public Double putEdge(int source, int target, double weight) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Double removeEdge(int source, int target) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%s(%d) {%n", "Graph", this.size()));
        for (Edge e : this.edges()) {
            sb.append(String.format("  %s%n", e));
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof Graph)) {
            return false;
        }
        Graph that = (Graph)obj;
        return Graphs.equals(this, that);
    }

    @Override
    public final int hashCode() {
        int hash = 1;
        for (int i = 0; i < this.size(); ++i) {
            hash = 31 * hash;
            for (int j : this.getEdges(i)) {
                hash += j;
            }
        }
        return hash;
    }
}

