/*
 * Decompiled with CFR 0.152.
 */
package gr.james.simplegraph;

import gr.james.simplegraph.AbstractIterator;
import gr.james.simplegraph.DirectedGraph;
import gr.james.simplegraph.Graph;
import gr.james.simplegraph.Graphs;
import gr.james.simplegraph.MutableDirectedGraph;
import gr.james.simplegraph.WeightedDirectedEdge;
import gr.james.simplegraph.WeightedDirectedEdgeImpl;
import gr.james.simplegraph.WeightedDirectedGraph;
import gr.james.simplegraph.WeightedGraph;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MutableWeightedDirectedGraph
implements WeightedDirectedGraph {
    private static final long serialVersionUID = 1L;
    private final List<Map<Integer, Double>> outEdges;
    private final List<Map<Integer, Double>> inEdges;

    public MutableWeightedDirectedGraph() {
        this.inEdges = new ArrayList<Map<Integer, Double>>();
        this.outEdges = new ArrayList<Map<Integer, Double>>();
    }

    public MutableWeightedDirectedGraph(int n) {
        this.inEdges = new ArrayList<Map<Integer, Double>>(n);
        this.outEdges = new ArrayList<Map<Integer, Double>>(n);
        this.addVertices(n);
        assert (this.size() == n);
    }

    public MutableWeightedDirectedGraph(WeightedDirectedGraph g) {
        this(g.size());
        for (WeightedDirectedEdge e : g.edges()) {
            this.putEdge(e.source(), e.target(), e.weight());
        }
        assert (g.equals(this));
    }

    public MutableWeightedDirectedGraph(DirectedGraph g) {
        this(g.asWeightedDirected());
    }

    public MutableWeightedDirectedGraph(WeightedGraph g) {
        this(g.asWeightedDirected());
    }

    public MutableWeightedDirectedGraph(Graph g) {
        this(g.asWeightedDirected());
    }

    @Override
    public int size() {
        assert (this.inEdges.size() == this.outEdges.size());
        return this.inEdges.size();
    }

    @Override
    public Set<Integer> getOutEdges(int v) {
        Map<Integer, Double> edges = this.outEdges.get(v);
        return Collections.unmodifiableSet(edges.keySet());
    }

    @Override
    public Set<Integer> getInEdges(int v) {
        Map<Integer, Double> edges = this.inEdges.get(v);
        return Collections.unmodifiableSet(edges.keySet());
    }

    @Override
    public double getEdgeWeight(int source, int target) {
        Graphs.requireVertexInGraph(this, target);
        Double weight = this.outEdges.get(source).get(target);
        if (weight == null) {
            throw new IllegalArgumentException();
        }
        assert (weight.equals(this.inEdges.get(target).get(source)));
        assert (Graphs.isWeightLegal(weight));
        return weight;
    }

    @Override
    public final Iterable<WeightedDirectedEdge> edges() {
        return new Iterable<WeightedDirectedEdge>(){

            @Override
            public Iterator<WeightedDirectedEdge> iterator() {
                return new AbstractIterator<WeightedDirectedEdge>(){
                    private int currentVertex;
                    private Iterator<Integer> edges;

                    @Override
                    void init() {
                        this.currentVertex = -1;
                        this.edges = Graphs.emptyIterator();
                    }

                    @Override
                    WeightedDirectedEdge computeNext() {
                        while (true) {
                            if (this.currentVertex >= MutableWeightedDirectedGraph.this.size()) {
                                return null;
                            }
                            if (this.currentVertex == MutableWeightedDirectedGraph.this.size() - 1 && !this.edges.hasNext()) {
                                return null;
                            }
                            if (this.edges.hasNext()) break;
                            this.edges = MutableWeightedDirectedGraph.this.getOutEdges(++this.currentVertex).iterator();
                        }
                        int e = this.edges.next();
                        return new WeightedDirectedEdgeImpl(this.currentVertex, e, MutableWeightedDirectedGraph.this.getEdgeWeight(this.currentVertex, e));
                    }
                };
            }
        };
    }

    public void addVertex() {
        this.inEdges.add(new HashMap());
        this.outEdges.add(new HashMap());
    }

    public final void addVertices(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < n; ++i) {
            this.addVertex();
        }
    }

    public void removeVertex(int v) {
        Graphs.requireVertexInGraph(this, v);
        for (int i = 0; i < this.size(); ++i) {
            Map<Integer, Double> previousOut = this.outEdges.get(i);
            HashMap<Integer, Double> newOut = new HashMap<Integer, Double>();
            for (Map.Entry<Integer, Double> e : previousOut.entrySet()) {
                if (e.getKey() > v) {
                    newOut.put(e.getKey() - 1, e.getValue());
                    continue;
                }
                if (e.getKey() >= v) continue;
                newOut.put(e.getKey(), e.getValue());
            }
            this.outEdges.set(i, newOut);
            Map<Integer, Double> previousIn = this.inEdges.get(i);
            HashMap<Integer, Double> newIn = new HashMap<Integer, Double>();
            for (Map.Entry<Integer, Double> e : previousIn.entrySet()) {
                if (e.getKey() > v) {
                    newIn.put(e.getKey() - 1, e.getValue());
                    continue;
                }
                if (e.getKey() >= v) continue;
                newIn.put(e.getKey(), e.getValue());
            }
            this.inEdges.set(i, newIn);
        }
        this.outEdges.remove(v);
        this.inEdges.remove(v);
    }

    public Double putEdge(int source, int target, double weight) {
        Graphs.requireWeightLegal(weight);
        Double a = this.outEdges.get(source).put(target, weight);
        Double b = this.inEdges.get(target).put(source, weight);
        assert (a != null ? a.equals(b) : b == null);
        return a;
    }

    public Double removeEdge(int source, int target) {
        Double a = this.outEdges.get(source).remove(target);
        Double b = this.inEdges.get(target).remove(source);
        assert (a != null ? a.equals(b) : b == null);
        return a;
    }

    public final WeightedDirectedGraph toImmutable() {
        return new MutableWeightedDirectedGraph(this).asUnmodifiable();
    }

    public final WeightedDirectedGraph asUnmodifiable() {
        return new MutableWeightedDirectedGraph(){

            @Override
            public int size() {
                return MutableWeightedDirectedGraph.this.size();
            }

            @Override
            public Set<Integer> getOutEdges(int v) {
                return MutableWeightedDirectedGraph.this.getOutEdges(v);
            }

            @Override
            public Set<Integer> getInEdges(int v) {
                return MutableWeightedDirectedGraph.this.getInEdges(v);
            }

            @Override
            public double getEdgeWeight(int source, int target) {
                return MutableWeightedDirectedGraph.this.getEdgeWeight(source, target);
            }

            @Override
            public void addVertex() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void removeVertex(int v) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Double putEdge(int source, int target, double weight) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Double removeEdge(int source, int target) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public final MutableDirectedGraph asDirected() {
        return new MutableDirectedGraph(){

            @Override
            public int size() {
                return MutableWeightedDirectedGraph.this.size();
            }

            @Override
            public Set<Integer> getOutEdges(int v) {
                return MutableWeightedDirectedGraph.this.getOutEdges(v);
            }

            @Override
            public Set<Integer> getInEdges(int v) {
                return MutableWeightedDirectedGraph.this.getInEdges(v);
            }

            @Override
            public void addVertex() {
                MutableWeightedDirectedGraph.this.addVertex();
            }

            @Override
            public void removeVertex(int v) {
                MutableWeightedDirectedGraph.this.removeVertex(v);
            }

            @Override
            public boolean putEdge(int source, int target) {
                return MutableWeightedDirectedGraph.this.putEdge(source, target, 1.0) == null;
            }

            @Override
            public boolean removeEdge(int source, int target) {
                return MutableWeightedDirectedGraph.this.removeEdge(source, target) != null;
            }
        };
    }

    @Override
    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%s(%d) {%n", "WeightedDirectedGraph", this.size()));
        for (WeightedDirectedEdge e : this.edges()) {
            sb.append(String.format("  %s%n", e));
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof WeightedDirectedGraph)) {
            return false;
        }
        WeightedDirectedGraph that = (WeightedDirectedGraph)obj;
        return Graphs.equals(this, that);
    }

    @Override
    public final int hashCode() {
        int hash = 1;
        for (int i = 0; i < this.size(); ++i) {
            hash = 31 * hash;
            for (int j : this.getOutEdges(i)) {
                hash += j ^ new Double(this.getEdgeWeight(i, j)).hashCode();
            }
        }
        return hash;
    }
}

