/*
 * Decompiled with CFR 0.152.
 */
package gr.james.simplegraph;

import gr.james.simplegraph.AbstractIterator;
import gr.james.simplegraph.Graph;
import gr.james.simplegraph.Graphs;
import gr.james.simplegraph.MutableDirectedGraph;
import gr.james.simplegraph.MutableGraph;
import gr.james.simplegraph.MutableWeightedDirectedGraph;
import gr.james.simplegraph.WeightedEdge;
import gr.james.simplegraph.WeightedEdgeImpl;
import gr.james.simplegraph.WeightedGraph;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MutableWeightedGraph
implements WeightedGraph {
    private static final long serialVersionUID = 1L;
    private final List<Map<Integer, Double>> edges;

    public MutableWeightedGraph() {
        this.edges = new ArrayList<Map<Integer, Double>>();
    }

    public MutableWeightedGraph(int n) {
        this.edges = new ArrayList<Map<Integer, Double>>(n);
        this.addVertices(n);
        assert (this.size() == n);
    }

    public MutableWeightedGraph(WeightedGraph g) {
        this(g.size());
        for (WeightedEdge e : g.edges()) {
            this.putEdge(e.v(), e.w(), e.weight());
        }
        assert (g.equals(this));
    }

    public MutableWeightedGraph(Graph g) {
        this(g.asWeighted());
    }

    @Override
    public int size() {
        return this.edges.size();
    }

    @Override
    public Set<Integer> getEdges(int v) {
        Map<Integer, Double> edges = this.edges.get(v);
        return Collections.unmodifiableSet(edges.keySet());
    }

    @Override
    public double getEdgeWeight(int v, int w) {
        Graphs.requireVertexInGraph(this, w);
        Double weight = this.edges.get(v).get(w);
        if (weight == null) {
            throw new IllegalArgumentException();
        }
        assert (weight.equals(this.edges.get(w).get(v)));
        assert (Graphs.isWeightLegal(weight));
        return weight;
    }

    @Override
    public final Iterable<WeightedEdge> edges() {
        return new Iterable<WeightedEdge>(){

            @Override
            public Iterator<WeightedEdge> iterator() {
                return new AbstractIterator<WeightedEdge>(){
                    private int currentVertex;
                    private Iterator<Integer> edges;

                    @Override
                    void init() {
                        this.currentVertex = -1;
                        this.edges = Graphs.emptyIterator();
                    }

                    @Override
                    WeightedEdge computeNext() {
                        int e;
                        while (true) {
                            if (this.currentVertex >= MutableWeightedGraph.this.size()) {
                                return null;
                            }
                            if (this.currentVertex == MutableWeightedGraph.this.size() - 1 && !this.edges.hasNext()) {
                                return null;
                            }
                            if (!this.edges.hasNext()) {
                                this.edges = MutableWeightedGraph.this.getEdges(++this.currentVertex).iterator();
                                continue;
                            }
                            e = this.edges.next();
                            if (e >= this.currentVertex) break;
                        }
                        return new WeightedEdgeImpl(this.currentVertex, e, MutableWeightedGraph.this.getEdgeWeight(this.currentVertex, e));
                    }
                };
            }
        };
    }

    public void addVertex() {
        this.edges.add(new HashMap());
    }

    public final void addVertices(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < n; ++i) {
            this.addVertex();
        }
    }

    public void removeVertex(int v) {
        Graphs.requireVertexInGraph(this, v);
        for (int i = 0; i < this.size(); ++i) {
            Map<Integer, Double> previousOut = this.edges.get(i);
            HashMap<Integer, Double> newOut = new HashMap<Integer, Double>();
            for (Map.Entry<Integer, Double> e : previousOut.entrySet()) {
                if (e.getKey() > v) {
                    newOut.put(e.getKey() - 1, e.getValue());
                    continue;
                }
                if (e.getKey() >= v) continue;
                newOut.put(e.getKey(), e.getValue());
            }
            this.edges.set(i, newOut);
        }
        this.edges.remove(v);
    }

    public Double putEdge(int v, int w, double weight) {
        Graphs.requireWeightLegal(weight);
        Double a = this.edges.get(v).put(w, weight);
        Double b = this.edges.get(w).put(v, weight);
        assert (a != null ? a.equals(b) : b == null);
        return a;
    }

    public Double removeEdge(int v, int w) {
        Double a = this.edges.get(v).remove(w);
        Double b = this.edges.get(w).remove(v);
        assert (a != null ? a.equals(b) : b == null);
        return a;
    }

    public final WeightedGraph toImmutable() {
        return new MutableWeightedGraph(this).asUnmodifiable();
    }

    public final WeightedGraph asUnmodifiable() {
        return new MutableWeightedGraph(){

            @Override
            public int size() {
                return MutableWeightedGraph.this.size();
            }

            @Override
            public Set<Integer> getEdges(int v) {
                return MutableWeightedGraph.this.getEdges(v);
            }

            @Override
            public double getEdgeWeight(int v, int w) {
                return MutableWeightedGraph.this.getEdgeWeight(v, w);
            }

            @Override
            public void addVertex() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void removeVertex(int v) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Double putEdge(int v, int w, double weight) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Double removeEdge(int v, int w) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public final MutableGraph asGraph() {
        return new MutableGraph(){

            @Override
            public int size() {
                return MutableWeightedGraph.this.size();
            }

            @Override
            public Set<Integer> getEdges(int v) {
                return MutableWeightedGraph.this.getEdges(v);
            }

            @Override
            public void addVertex() {
                MutableWeightedGraph.this.addVertex();
            }

            @Override
            public void removeVertex(int v) {
                MutableWeightedGraph.this.removeVertex(v);
            }

            @Override
            public boolean putEdge(int v, int w) {
                return MutableWeightedGraph.this.putEdge(v, w, 1.0) == null;
            }

            @Override
            public boolean removeEdge(int v, int w) {
                return MutableWeightedGraph.this.removeEdge(v, w) != null;
            }
        };
    }

    @Override
    public final MutableDirectedGraph asDirected() {
        return new MutableDirectedGraph(){

            @Override
            public int size() {
                return MutableWeightedGraph.this.size();
            }

            @Override
            public Set<Integer> getOutEdges(int v) {
                return MutableWeightedGraph.this.getEdges(v);
            }

            @Override
            public Set<Integer> getInEdges(int v) {
                return MutableWeightedGraph.this.getEdges(v);
            }

            @Override
            public void addVertex() {
                MutableWeightedGraph.this.addVertex();
            }

            @Override
            public void removeVertex(int v) {
                MutableWeightedGraph.this.removeVertex(v);
            }

            @Override
            public boolean putEdge(int source, int target) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean removeEdge(int source, int target) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public final MutableWeightedDirectedGraph asWeightedDirected() {
        return new MutableWeightedDirectedGraph(){

            @Override
            public int size() {
                return MutableWeightedGraph.this.size();
            }

            @Override
            public Set<Integer> getOutEdges(int v) {
                return MutableWeightedGraph.this.getEdges(v);
            }

            @Override
            public Set<Integer> getInEdges(int v) {
                return MutableWeightedGraph.this.getEdges(v);
            }

            @Override
            public double getEdgeWeight(int source, int target) {
                return MutableWeightedGraph.this.getEdgeWeight(source, target);
            }

            @Override
            public void addVertex() {
                MutableWeightedGraph.this.addVertex();
            }

            @Override
            public void removeVertex(int v) {
                MutableWeightedGraph.this.removeVertex(v);
            }

            @Override
            public Double putEdge(int source, int target, double weight) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Double removeEdge(int source, int target) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%s(%d) {%n", "WeightedGraph", this.size()));
        for (WeightedEdge e : this.edges()) {
            sb.append(String.format("  %s%n", e));
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof WeightedGraph)) {
            return false;
        }
        WeightedGraph that = (WeightedGraph)obj;
        return Graphs.equals(this, that);
    }

    @Override
    public final int hashCode() {
        int hash = 1;
        for (int i = 0; i < this.size(); ++i) {
            hash = 31 * hash;
            for (int j : this.getEdges(i)) {
                hash += j ^ new Double(this.getEdgeWeight(i, j)).hashCode();
            }
        }
        return hash;
    }
}

