/*
 * Decompiled with CFR 0.152.
 */
package gr.james.simplegraph;

import gr.james.simplegraph.WeightedEdge;
import java.util.Arrays;

final class WeightedEdgeImpl
implements WeightedEdge {
    private final int v;
    private final int w;
    private final double weight;

    WeightedEdgeImpl(int v, int w, double weight) {
        this.v = v;
        this.w = w;
        this.weight = weight;
    }

    @Override
    public int v() {
        return this.v;
    }

    @Override
    public int w() {
        return this.w;
    }

    @Override
    public double weight() {
        return this.weight;
    }

    @Override
    public WeightedEdge swap() {
        WeightedEdgeImpl e = new WeightedEdgeImpl(this.w, this.v, this.weight);
        assert (this.equals(e));
        return e;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof WeightedEdge)) {
            return false;
        }
        WeightedEdge that = (WeightedEdge)obj;
        return Math.min(this.v(), this.w()) == Math.min(that.v(), that.w()) && Math.max(this.v(), this.w()) == Math.max(that.v(), that.w()) && this.weight() == that.weight();
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(new Object[]{Math.min(this.v(), this.w()), Math.max(this.v(), this.w()), this.weight()});
    }

    @Override
    public String toString() {
        return String.format("%d -- %d [%.2f]", this.v(), this.w(), this.weight());
    }
}

