/*
 * Decompiled with CFR 0.152.
 */
package gr.james.simplegraph.examples;

import gr.james.simplegraph.DirectedGraph;
import gr.james.simplegraph.Graph;
import gr.james.simplegraph.Graphs;
import gr.james.simplegraph.WeightedDirectedGraph;
import gr.james.simplegraph.WeightedGraph;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Set;

public class BreadthFirstIterator
implements Iterator<Integer> {
    private final DirectedGraph g;
    private final Deque<Integer> queue;
    private final Set<Integer> visited;

    public BreadthFirstIterator(DirectedGraph g, int source) {
        Graphs.requireVertexInGraph(g, source);
        this.g = g;
        this.queue = new LinkedList<Integer>();
        this.visited = new HashSet<Integer>();
        this.queue.offer(source);
        this.visited.add(source);
    }

    public BreadthFirstIterator(Graph g, int source) {
        this(g.asDirected(), source);
    }

    public BreadthFirstIterator(WeightedGraph g, int source) {
        this(g.asDirected(), source);
    }

    public BreadthFirstIterator(WeightedDirectedGraph g, int source) {
        this(g.asDirected(), source);
    }

    @Override
    public boolean hasNext() {
        return !this.queue.isEmpty();
    }

    @Override
    public Integer next() {
        Integer next = this.queue.poll();
        if (next == null) {
            throw new NoSuchElementException();
        }
        for (int v : this.g.getOutEdges(next)) {
            if (!this.visited.add(v)) continue;
            this.queue.offer(v);
        }
        return next;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

