/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.util.CharArraySet;
import org.apache.lucene.util.Version;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.FailedToResolveConfigException;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.analysis.Analysis;
import org.elasticsearch.index.analysis.SkroutzGreekStemTokenFilter;
import org.elasticsearch.index.analysis.SkroutzGreekStemmer;
import org.elasticsearch.index.settings.IndexSettings;

public class SkroutzGreekStemmerTokenFilterFactory
extends AbstractTokenFilterFactory {
    private final CharArraySet stopwords;

    @Inject
    public SkroutzGreekStemmerTokenFilterFactory(Index index, @IndexSettings Settings indexSettings, Environment env, @Assisted String name, @Assisted Settings settings) throws IOException {
        super(index, indexSettings, name, settings);
        this.stopwords = this.parseStopWords(env, settings, "stopwords_path", Lucene.VERSION);
    }

    public TokenStream create(TokenStream tokenStream) {
        return new SkroutzGreekStemTokenFilter(tokenStream, this.stopwords);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CharArraySet parseStopWords(Environment env, Settings settings, String settingPrefix, Version version) throws IOException {
        List stopwordList = new ArrayList();
        Reader stopwordsReader = null;
        try {
            stopwordsReader = Analysis.getReaderFromFile((Environment)env, (Settings)settings, (String)settingPrefix);
        }
        catch (FailedToResolveConfigException e) {
            this.logger.info("failed to find stopwords path, using the default stopword set", new Object[0]);
        }
        if (stopwordsReader != null) {
            try {
                stopwordList = Analysis.loadWordList((Reader)stopwordsReader, (String)"#");
                if (stopwordList.isEmpty()) {
                    CharArraySet charArraySet = CharArraySet.EMPTY_SET;
                    return charArraySet;
                }
                CharArraySet charArraySet = new CharArraySet(version, stopwordList, false);
                return charArraySet;
            }
            finally {
                if (stopwordsReader != null) {
                    stopwordsReader.close();
                }
            }
        }
        return SkroutzGreekStemmer.getDefaultStopSet();
    }
}

