/*
 * Decompiled with CFR 0.152.
 */
package group.flyfish.rest.configuration;

import group.flyfish.rest.configuration.RestClientProperties;
import group.flyfish.rest.core.factory.DefaultHttpClientProvider;
import group.flyfish.rest.core.factory.HttpClientFactoryBean;
import group.flyfish.rest.core.factory.HttpClientProvider;
import group.flyfish.rest.mapping.RestResultMapping;
import group.flyfish.rest.registry.RestApiRegistry;
import group.flyfish.rest.registry.proxy.support.RestArgumentResolver;
import group.flyfish.rest.registry.proxy.support.RestArgumentResolverComposite;
import group.flyfish.rest.registry.proxy.support.resolvers.RestBodyArgumentResolver;
import group.flyfish.rest.registry.proxy.support.resolvers.RestHeaderArgumentResolver;
import group.flyfish.rest.registry.proxy.support.resolvers.RestParamArgumentResolver;
import group.flyfish.rest.registry.proxy.support.resolvers.RestPartArgumentResolver;
import group.flyfish.rest.registry.proxy.support.resolvers.RestPathParamArgumentResolver;
import group.flyfish.rest.utils.DataUtils;
import java.util.Arrays;
import java.util.List;
import org.apache.http.impl.client.CloseableHttpClient;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;

public class RestClientConfiguration {
    @ConfigurationProperties(prefix="rest.client", ignoreUnknownFields=false)
    @Bean
    public RestClientProperties restClientProperties() {
        return new RestClientProperties();
    }

    @Bean
    @ConditionalOnMissingBean(value={CloseableHttpClient.class})
    public HttpClientFactoryBean httpClientFactoryBean() {
        return new HttpClientFactoryBean();
    }

    @Bean
    @ConditionalOnMissingBean
    public HttpClientProvider httpClientProvider() {
        return new DefaultHttpClientProvider();
    }

    @Bean
    public RestApiRegistry restApiRegistry(RestArgumentResolverComposite composite, HttpClientProvider provider, List<RestResultMapping> mappings) {
        if (DataUtils.isNotEmpty(mappings)) {
            mappings.forEach(mapping -> RestResultMapping.MAPPINGS.put(mapping.getClass(), mapping));
        }
        return new RestApiRegistry(composite, provider);
    }

    @Bean
    public RestArgumentResolverComposite restArgumentResolverComposite() {
        List<RestArgumentResolver> resolvers = Arrays.asList(new RestPathParamArgumentResolver(), new RestPartArgumentResolver(), new RestPartArgumentResolver.FilenameResolver(), new RestBodyArgumentResolver(), new RestHeaderArgumentResolver(), new RestParamArgumentResolver());
        return new RestArgumentResolverComposite(resolvers);
    }
}

