/*
 * Decompiled with CFR 0.152.
 */
package group.flyfish.rest.configuration;

import group.flyfish.rest.configuration.configure.PropertiesConfigurable;
import group.flyfish.rest.configuration.modifier.RestPropertiesModifier;
import group.flyfish.rest.core.auth.RestAuthProvider;
import group.flyfish.rest.registry.proxy.RestInvokers;
import group.flyfish.rest.utils.DataUtils;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public class RestClientProperties
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(RestClientProperties.class);
    private Duration connectionTimeout = Duration.ofSeconds(30L);
    private String baseUrl;
    private Boolean alwaysTrust = true;
    private Map<String, String> urls = new HashMap<String, String>();
    private RestAuthProvider authProvider;
    private List<RestPropertiesModifier> modifiers;
    private List<PropertiesConfigurable> configures;

    public String getDictUrl(String key) {
        if (DataUtils.isEmpty(this.urls)) {
            return null;
        }
        return this.urls.get(key);
    }

    @Autowired(required=false)
    public void setDefaultAuthProvider(RestAuthProvider provider) {
        this.authProvider = provider;
    }

    @Autowired(required=false)
    public void setModifiers(List<RestPropertiesModifier> modifiers) {
        this.modifiers = modifiers;
    }

    @Autowired(required=false)
    public void setConfigures(List<PropertiesConfigurable> configures) {
        this.configures = configures;
    }

    public void afterPropertiesSet() {
        if (DataUtils.isNotEmpty(this.modifiers)) {
            this.modifiers.forEach(modifier -> modifier.modify(this));
        }
        if (DataUtils.isNotEmpty(this.configures)) {
            this.configures.forEach(item -> item.configure(this));
        }
        RestInvokers.configure(this);
    }

    public Duration getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public Boolean getAlwaysTrust() {
        return this.alwaysTrust;
    }

    public Map<String, String> getUrls() {
        return this.urls;
    }

    public RestAuthProvider getAuthProvider() {
        return this.authProvider;
    }

    public void setConnectionTimeout(Duration connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public void setAlwaysTrust(Boolean alwaysTrust) {
        this.alwaysTrust = alwaysTrust;
    }

    public void setUrls(Map<String, String> urls) {
        this.urls = urls;
    }

    public void setAuthProvider(RestAuthProvider authProvider) {
        this.authProvider = authProvider;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RestClientProperties)) {
            return false;
        }
        RestClientProperties other = (RestClientProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$alwaysTrust = this.getAlwaysTrust();
        Boolean other$alwaysTrust = other.getAlwaysTrust();
        if (this$alwaysTrust == null ? other$alwaysTrust != null : !((Object)this$alwaysTrust).equals(other$alwaysTrust)) {
            return false;
        }
        Duration this$connectionTimeout = this.getConnectionTimeout();
        Duration other$connectionTimeout = other.getConnectionTimeout();
        if (this$connectionTimeout == null ? other$connectionTimeout != null : !((Object)this$connectionTimeout).equals(other$connectionTimeout)) {
            return false;
        }
        String this$baseUrl = this.getBaseUrl();
        String other$baseUrl = other.getBaseUrl();
        if (this$baseUrl == null ? other$baseUrl != null : !this$baseUrl.equals(other$baseUrl)) {
            return false;
        }
        Map<String, String> this$urls = this.getUrls();
        Map<String, String> other$urls = other.getUrls();
        if (this$urls == null ? other$urls != null : !((Object)this$urls).equals(other$urls)) {
            return false;
        }
        RestAuthProvider this$authProvider = this.getAuthProvider();
        RestAuthProvider other$authProvider = other.getAuthProvider();
        if (this$authProvider == null ? other$authProvider != null : !this$authProvider.equals(other$authProvider)) {
            return false;
        }
        List<RestPropertiesModifier> this$modifiers = this.modifiers;
        List<RestPropertiesModifier> other$modifiers = other.modifiers;
        if (this$modifiers == null ? other$modifiers != null : !((Object)this$modifiers).equals(other$modifiers)) {
            return false;
        }
        List<PropertiesConfigurable> this$configures = this.configures;
        List<PropertiesConfigurable> other$configures = other.configures;
        return !(this$configures == null ? other$configures != null : !((Object)this$configures).equals(other$configures));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RestClientProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $alwaysTrust = this.getAlwaysTrust();
        result = result * 59 + ($alwaysTrust == null ? 43 : ((Object)$alwaysTrust).hashCode());
        Duration $connectionTimeout = this.getConnectionTimeout();
        result = result * 59 + ($connectionTimeout == null ? 43 : ((Object)$connectionTimeout).hashCode());
        String $baseUrl = this.getBaseUrl();
        result = result * 59 + ($baseUrl == null ? 43 : $baseUrl.hashCode());
        Map<String, String> $urls = this.getUrls();
        result = result * 59 + ($urls == null ? 43 : ((Object)$urls).hashCode());
        RestAuthProvider $authProvider = this.getAuthProvider();
        result = result * 59 + ($authProvider == null ? 43 : $authProvider.hashCode());
        List<RestPropertiesModifier> $modifiers = this.modifiers;
        result = result * 59 + ($modifiers == null ? 43 : ((Object)$modifiers).hashCode());
        List<PropertiesConfigurable> $configures = this.configures;
        result = result * 59 + ($configures == null ? 43 : ((Object)$configures).hashCode());
        return result;
    }

    public String toString() {
        return "RestClientProperties(connectionTimeout=" + this.getConnectionTimeout() + ", baseUrl=" + this.getBaseUrl() + ", alwaysTrust=" + this.getAlwaysTrust() + ", urls=" + this.getUrls() + ", authProvider=" + this.getAuthProvider() + ", modifiers=" + this.modifiers + ", configures=" + this.configures + ")";
    }
}

